/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.task.analyser.performance;

import com.didiglobal.booster.task.analyser.performance.ConstantsKt;
import com.didiglobal.booster.task.analyser.performance.PerformanceAnalyser;
import com.didiglobal.booster.transform.asm.AnnotationNodeKt;
import com.didiglobal.booster.transform.asm.ClassNodeKt;
import com.didiglobal.booster.transform.asm.MethodNodeKt;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0011*\u00020\u0012H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0014\u0010\t\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\"\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\"\u0018\u0010\u0014\u001a\u00020\u0011*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\u001a"}, d2={"EVENTBUS_SUBSCRIBE", "", "EVENTBUS_THREAD_MODE", "PROPERTY_BLACKLIST", "PROPERTY_PREFIX", "PROPERTY_WHITELIST", "VALUE_BLACKLIST", "getVALUE_BLACKLIST", "()Ljava/lang/String;", "VALUE_WHITELIST", "getVALUE_WHITELIST", "bootClasspath", "", "Ljava/io/File;", "getBootClasspath", "(Ljava/io/File;)Ljava/util/Collection;", "isEntryPoint", "", "Lorg/objectweb/asm/tree/MethodNode;", "(Lorg/objectweb/asm/tree/MethodNode;)Z", "isInclude", "Lorg/objectweb/asm/tree/ClassNode;", "(Lorg/objectweb/asm/tree/ClassNode;)Z", "descriptor", "name", "isSubscribeOnMainThread", "booster-task-analyser"})
public final class PerformanceAnalyserKt {
    @NotNull
    private static final String EVENTBUS_SUBSCRIBE = "Lorg/greenrobot/eventbus/Subscribe;";
    @NotNull
    private static final String EVENTBUS_THREAD_MODE = "Lorg/greenrobot/eventbus/ThreadMode;";
    @NotNull
    private static final String PROPERTY_PREFIX = StringsKt.replace$default((String)"booster-task-analyser", (char)'-', (char)'.', (boolean)false, (int)4, null);
    @NotNull
    private static final String PROPERTY_BLACKLIST = Intrinsics.stringPlus((String)PROPERTY_PREFIX, (Object)".blacklist");
    @NotNull
    private static final String PROPERTY_WHITELIST = Intrinsics.stringPlus((String)PROPERTY_PREFIX, (Object)".whitelist");
    @NotNull
    private static final String VALUE_BLACKLIST;
    @NotNull
    private static final String VALUE_WHITELIST;

    private static final Collection<File> getBootClasspath(File $this$bootClasspath) {
        Object[] objectArray = new File[]{FilesKt.resolve((File)$this$bootClasspath, (String)"android.jar"), FilesKt.resolve((File)FilesKt.resolve((File)$this$bootClasspath, (String)"optional"), (String)"org.apache.http.legacy.jar")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final boolean isSubscribeOnMainThread(@NotNull MethodNode $this$isSubscribeOnMainThread) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isSubscribeOnMainThread, (String)"<this>");
        List list = $this$isSubscribeOnMainThread.visibleAnnotations;
        if (list == null) {
            bl = false;
        } else {
            Object v1;
            Object[] objectArray;
            boolean bl2;
            String[] stringArray;
            block7: {
                stringArray = (String[])list;
                bl2 = false;
                objectArray = stringArray;
                boolean bl3 = false;
                for (Object t : objectArray) {
                    AnnotationNode it = (AnnotationNode)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.desc, (Object)EVENTBUS_SUBSCRIBE)) continue;
                    v1 = t;
                    break block7;
                }
                v1 = null;
            }
            AnnotationNode annotationNode = v1;
            if (annotationNode == null) {
                bl = false;
            } else {
                stringArray = (String[])AnnotationNodeKt.getValue((AnnotationNode)annotationNode, (String)"threadMode");
                if (stringArray == null) {
                    bl = false;
                } else {
                    objectArray = stringArray;
                    Object[] objectArray2 = new String[]{EVENTBUS_THREAD_MODE, "MAIN"};
                    boolean bl5 = false;
                    bl = bl2 = Arrays.equals(objectArray, objectArray2);
                }
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInclude(ClassNode $this$isInclude) {
        boolean bl;
        Regex regex = ConstantsKt.getEXCLUDES();
        Object object = $this$isInclude.name;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
        if (regex.matches((CharSequence)object)) return false;
        if (ClassNodeKt.isAnnotation((ClassNode)$this$isInclude)) return false;
        if (!ClassNodeKt.isInterface((ClassNode)$this$isInclude)) {
            if (!ClassNodeKt.isAbstract((ClassNode)$this$isInclude)) return true;
        }
        object = $this$isInclude.methods;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"methods");
        Iterable $this$none$iv = (Iterable)object;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            MethodNode it = (MethodNode)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!MethodNodeKt.isAbstract((MethodNode)it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isEntryPoint(MethodNode $this$isEntryPoint) {
        return (MethodNodeKt.isPublic((MethodNode)$this$isEntryPoint) || MethodNodeKt.isProtected((MethodNode)$this$isEntryPoint)) && !MethodNodeKt.isNative((MethodNode)$this$isEntryPoint) && !MethodNodeKt.isStatic((MethodNode)$this$isEntryPoint);
    }

    private static final String descriptor(String name) {
        return 'L' + name + ';';
    }

    @NotNull
    public static final String getVALUE_BLACKLIST() {
        return VALUE_BLACKLIST;
    }

    @NotNull
    public static final String getVALUE_WHITELIST() {
        return VALUE_WHITELIST;
    }

    public static final /* synthetic */ String access$getPROPERTY_BLACKLIST$p() {
        return PROPERTY_BLACKLIST;
    }

    public static final /* synthetic */ String access$getPROPERTY_WHITELIST$p() {
        return PROPERTY_WHITELIST;
    }

    public static final /* synthetic */ Collection access$getBootClasspath(File $receiver) {
        return PerformanceAnalyserKt.getBootClasspath($receiver);
    }

    public static final /* synthetic */ boolean access$isInclude(ClassNode $receiver) {
        return PerformanceAnalyserKt.isInclude($receiver);
    }

    public static final /* synthetic */ boolean access$isEntryPoint(MethodNode $receiver) {
        return PerformanceAnalyserKt.isEntryPoint($receiver);
    }

    public static final /* synthetic */ String access$descriptor(String name) {
        return PerformanceAnalyserKt.descriptor(name);
    }

    static {
        URL uRL = PerformanceAnalyser.class.getClassLoader().getResource("blacklist.txt");
        Intrinsics.checkNotNull((Object)uRL);
        String string = uRL.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PerformanceAnalyser::cla\u2026cklist.txt\")!!.toString()");
        VALUE_BLACKLIST = string;
        URL uRL2 = PerformanceAnalyser.class.getClassLoader().getResource("whitelist.txt");
        Intrinsics.checkNotNull((Object)uRL2);
        string = uRL2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PerformanceAnalyser::cla\u2026telist.txt\")!!.toString()");
        VALUE_WHITELIST = string;
    }
}

