/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.task.analyser.reference;

import com.android.build.gradle.api.BaseVariant;
import com.didiglobal.booster.cha.ClassSet;
import com.didiglobal.booster.cha.ClassSetKt;
import com.didiglobal.booster.cha.asm.AsmClassSetCache;
import com.didiglobal.booster.cha.asm.Reference;
import com.didiglobal.booster.cha.asm.ReferenceAnalyser;
import com.didiglobal.booster.gradle.ProjectKt;
import com.didiglobal.booster.graph.Graph;
import com.didiglobal.booster.graph.GraphRenderer;
import com.didiglobal.booster.graph.dot.DotGraph;
import com.didiglobal.booster.graph.json.JsonGraphRender;
import com.didiglobal.booster.kotlinx.AnsiKt;
import com.didiglobal.booster.task.analyser.AnalysisTask;
import com.didiglobal.booster.task.analyser.AnalysisTaskKt;
import com.didiglobal.booster.task.analyser.reference.ReferenceAnalysisTask;
import com.didiglobal.booster.task.analyser.reference.ReferencePageRenderer;
import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0016\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/didiglobal/booster/task/analyser/reference/ReferenceAnalysisTask;", "Lcom/didiglobal/booster/task/analyser/AnalysisTask;", "()V", "analyse", "", "generateDotReport", "graph", "Lcom/didiglobal/booster/graph/Graph;", "Lcom/didiglobal/booster/cha/asm/Reference;", "generateHtmlReport", "generateJsonReport", "getDescription", "", "booster-task-analyser"})
public class ReferenceAnalysisTask
extends AnalysisTask {
    @Override
    @NotNull
    public String getDescription() {
        return "Analysing class reference for Android/Java projects";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @TaskAction
    public void analyse() {
        Future<?> future;
        KFunction[] $this$mapTo$iv$iv;
        void $this$map$iv;
        URL $this$map$iv2;
        Object object;
        void $this$associateTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$associate$iv = ProjectKt.getResolvedArtifactResults((Project)project, (boolean)true, (BaseVariant)this.getVariant());
        boolean $i$f$associate232 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object t : $this$associateTo$iv$iv) {
            ClassSet classSet;
            object = destination$iv$iv;
            ResolvedArtifactResult it = (ResolvedArtifactResult)t;
            boolean bl = false;
            String string = it.getId().getComponentIdentifier().getDisplayName();
            ComponentIdentifier id = it.getId().getComponentIdentifier();
            if (id instanceof ProjectComponentIdentifier) {
                Collection<ClassSet> collection;
                void $this$mapTo$iv$iv2;
                Object object2 = this.getProject().getRootProject().project(((ProjectComponentIdentifier)id).getProjectPath());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.rootProject.project(id.projectPath)");
                object2 = ProjectKt.getJars((Project)object2, (BaseVariant)this.getVariant());
                String string2 = string;
                boolean $i$f$map = false;
                URL uRL = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void file;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    AsmClassSetCache asmClassSetCache = this.getClassSetCache();
                    URL uRL2 = file.toURI().toURL();
                    Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"file.toURI().toURL()");
                    ClassSet classSet2 = asmClassSetCache.get(uRL2);
                    collection.add(classSet2);
                }
                collection = (List)destination$iv$iv2;
                string = string2;
                classSet = ClassSetKt.fold((Iterable)collection);
            } else {
                AsmClassSetCache asmClassSetCache = this.getClassSetCache();
                $this$map$iv2 = it.getFile().toURI().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv2, (String)"it.file.toURI().toURL()");
                classSet = asmClassSetCache.get($this$map$iv2);
            }
            it = TuplesKt.to((Object)string, (Object)classSet);
            boolean uRL = false;
            object.put(it.getFirst(), it.getSecond());
        }
        Map upstream = destination$iv$iv;
        String string = this.getProject().getName();
        Object $i$f$associate232 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$associate232, (String)"project");
        $i$f$associate232 = ProjectKt.getJars((Project)$i$f$associate232, (BaseVariant)this.getVariant());
        Object object3 = string;
        boolean $i$f$map = false;
        $this$associateTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            object = (File)t;
            future = destination$iv$iv;
            boolean bl = false;
            AsmClassSetCache asmClassSetCache = this.getClassSetCache();
            URL uRL = it.toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"it.toURI().toURL()");
            ClassSet classSet = asmClassSetCache.get(uRL);
            future.add(classSet);
        }
        future = (List)destination$iv$iv;
        Pair origin = TuplesKt.to((Object)object3, (Object)ClassSetKt.fold((Iterable)((Iterable)((Object)future))));
        Graph graph2 = new ReferenceAnalyser(0, 1, null).analyse(origin, upstream, (Function3)new Function3<ClassNode, Float, Duration, Unit>(this){
            final /* synthetic */ ReferenceAnalysisTask this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull ClassNode klass, float progress, @NotNull Duration duration) {
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
                Logger logger = this.this$0.getProject().getLogger();
                StringBuilder stringBuilder = new StringBuilder();
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%3f%%";
                Object[] objectArray = new Object[]{Float.valueOf(progress * (float)100)};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                logger.info(stringBuilder.append(AnsiKt.green((Object)string2)).append(" Analyse class ").append((Object)klass.name).append(" in ").append(AnsiKt.yellow((Object)duration.toMillis())).append(" ms").toString());
            }
        });
        ExecutorService executor = Executors.newFixedThreadPool(3);
        try {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv3;
            $this$mapTo$iv$iv = new KFunction[]{(KFunction)new Function1<Graph<Reference>, Unit>((Object)this){

                public final void invoke(@NotNull Graph<Reference> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    ReferenceAnalysisTask.access$generateHtmlReport((ReferenceAnalysisTask)((Object)this.receiver), p0);
                }

                @NotNull
                public final String getSignature() {
                    return "generateHtmlReport(Lcom/didiglobal/booster/graph/Graph;)V";
                }

                @NotNull
                public final String getName() {
                    return "generateHtmlReport";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ReferenceAnalysisTask.class);
                }
            }, (KFunction)new Function1<Graph<Reference>, Unit>((Object)this){

                public final void invoke(@NotNull Graph<Reference> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    ReferenceAnalysisTask.access$generateDotReport((ReferenceAnalysisTask)((Object)this.receiver), p0);
                }

                @NotNull
                public final String getSignature() {
                    return "generateDotReport(Lcom/didiglobal/booster/graph/Graph;)V";
                }

                @NotNull
                public final String getName() {
                    return "generateDotReport";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ReferenceAnalysisTask.class);
                }
            }, (KFunction)new Function1<Graph<Reference>, Unit>((Object)this){

                public final void invoke(@NotNull Graph<Reference> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    ReferenceAnalysisTask.access$generateJsonReport((ReferenceAnalysisTask)((Object)this.receiver), p0);
                }

                @NotNull
                public final String getSignature() {
                    return "generateJsonReport(Lcom/didiglobal/booster/graph/Graph;)V";
                }

                @NotNull
                public final String getName() {
                    return "generateJsonReport";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ReferenceAnalysisTask.class);
                }
            }};
            Object $this$map$iv3 = $this$mapTo$iv$iv;
            boolean $i$f$map2 = false;
            KFunction[] $i$f$mapTo22 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(((KFunction[])$this$map$iv3).length);
            boolean bl = false;
            for (void item$iv$iv : $this$mapTo$iv$iv3) {
                void render;
                $this$map$iv2 = item$iv$iv;
                object3 = destination$iv$iv3;
                boolean bl2 = false;
                future = executor.submit(() -> ReferenceAnalysisTask.analyse$lambda-4$lambda-3((KFunction)render, graph2));
                object3.add(future);
            }
            $this$map$iv3 = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Future future2 = (Future)element$iv;
                boolean bl3 = false;
                future2.get();
            }
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private final void generateDotReport(Graph<Reference> graph2) {
        try {
            DotGraph.DotOptions options = new DotGraph.DotOptions("svg", "LR");
            DotGraph.visualize$default((DotGraph)((DotGraph)DotGraph.DIGRAPH.INSTANCE), graph2, (File)AnalysisTaskKt.report(this, "dot"), (DotGraph.DotOptions)options, null, null, (int)24, null);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage());
        }
    }

    private final void generateHtmlReport(Graph<Reference> graph2) {
        HtmlReportRenderer htmlReportRenderer = new HtmlReportRenderer();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        htmlReportRenderer.renderSinglePage(graph2, (ReportRenderer)new ReferencePageRenderer(project, this.getVariant()), AnalysisTaskKt.report(this, "html"));
    }

    private final void generateJsonReport(Graph<Reference> graph2) {
        String json2 = ((Object)GraphRenderer.DefaultImpls.render$default((GraphRenderer)((GraphRenderer)JsonGraphRender.INSTANCE), graph2, null, (Function1)generateJsonReport.json.1.INSTANCE, (int)2, null)).toString();
        FilesKt.writeText$default((File)AnalysisTaskKt.report(this, "json"), (String)json2, null, (int)2, null);
    }

    private static final void analyse$lambda-4$lambda-3(KFunction $render, Graph $graph) {
        Intrinsics.checkNotNullParameter((Object)$render, (String)"$render");
        Intrinsics.checkNotNullParameter((Object)$graph, (String)"$graph");
        ((Function1)$render).invoke((Object)$graph);
    }

    public static final /* synthetic */ void access$generateHtmlReport(ReferenceAnalysisTask $this, Graph graph2) {
        $this.generateHtmlReport((Graph<Reference>)graph2);
    }

    public static final /* synthetic */ void access$generateDotReport(ReferenceAnalysisTask $this, Graph graph2) {
        $this.generateDotReport((Graph<Reference>)graph2);
    }

    public static final /* synthetic */ void access$generateJsonReport(ReferenceAnalysisTask $this, Graph graph2) {
        $this.generateJsonReport((Graph<Reference>)graph2);
    }
}

