/*
 * Decompiled with CFR 0.152.
 */
package com.didi.carmate.catalog.page;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.didi.carmate.catalog.view.DBPageContainer;
import com.didi.dreambox.catalog.R;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DBDisplayActivity
extends AppCompatActivity
implements View.OnClickListener {
    private TextView showViewBtn;
    private TextView showCodeBtn;
    private DBPageContainer displayView;
    private TextView displayCode;
    private String dbName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_db_display);
        this.showViewBtn = (TextView)this.findViewById(R.id.db_catalog_display);
        this.showCodeBtn = (TextView)this.findViewById(R.id.db_catalog_code);
        this.showViewBtn.setBackgroundResource(R.drawable.db_playground_btn_bg_selected);
        this.showCodeBtn.setBackgroundResource(R.drawable.db_playground_btn_bg);
        this.showViewBtn.setOnClickListener((View.OnClickListener)this);
        this.showCodeBtn.setOnClickListener((View.OnClickListener)this);
        this.displayView = (DBPageContainer)this.findViewById(R.id.db_catalog_display_view);
        this.displayCode = (TextView)this.findViewById(R.id.db_catalog_display_code);
        this.displayCode.setVisibility(8);
        this.displayCode.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.displayCode.setHorizontallyScrolling(true);
        this.displayCode.setFocusable(true);
        this.initData();
    }

    private void initData() {
        this.dbName = this.getName();
        String ext = this.getStringFromAssets(this.dbName + ".json");
        if (!TextUtils.isEmpty((CharSequence)ext)) {
            this.displayView.render(this.dbName, ext);
        } else {
            this.displayView.render(this.dbName);
        }
        this.displayCode.setText((CharSequence)this.prettyFormat(this.dbName));
    }

    private String getName() {
        Intent intent = this.getIntent();
        return intent.getStringExtra("name");
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.db_catalog_display) {
            this.showViewBtn.setBackgroundResource(R.drawable.db_playground_btn_bg_selected);
            this.showCodeBtn.setBackgroundResource(R.drawable.db_playground_btn_bg);
            this.displayView.setVisibility(0);
            this.displayCode.setVisibility(8);
        } else if (id2 == R.id.db_catalog_code) {
            this.showCodeBtn.setBackgroundResource(R.drawable.db_playground_btn_bg_selected);
            this.showViewBtn.setBackgroundResource(R.drawable.db_playground_btn_bg);
            this.displayView.setVisibility(8);
            this.displayCode.setVisibility(0);
        }
    }

    public String prettyFormat(String fileName) {
        String result = null;
        try {
            InputStream is = this.getAssets().open(fileName + ".xml");
            int length = is.available();
            byte[] buffer = new byte[length];
            is.read(buffer);
            result = new String(buffer, "utf8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty(result)) {
            Log.e((String)"DBDisplayActivity", (String)"\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff01\uff01\uff01");
            return null;
        }
        return result;
    }

    private String getStringFromAssets(String fileName) {
        StringBuilder jsonSb = new StringBuilder();
        try {
            String in;
            InputStream is = this.getAssets().open(fileName);
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            BufferedReader bfr = new BufferedReader(isr);
            while ((in = bfr.readLine()) != null) {
                jsonSb.append(in);
            }
            is.close();
            isr.close();
            bfr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonSb.toString();
    }
}

