/*
 * Decompiled with CFR 0.152.
 */
package com.didispace.scca.service.discovery.consul;

import com.didispace.scca.core.domain.Env;
import com.didispace.scca.core.service.impl.BaseUrlMaker;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlMaker4Consul
extends BaseUrlMaker {
    private static final Logger log = LoggerFactory.getLogger(UrlMaker4Consul.class);

    public String configServerBaseUrl(String envName) {
        Env env = this.envRepo.findByName(envName);
        if (env.getRegistryAddress() == null || env.getRegistryAddress().isEmpty()) {
            return super.configServerBaseUrl(envName);
        }
        ConsulClient consulClient = new ConsulClient(env.getRegistryAddress());
        Response response = consulClient.getHealthServices(env.getConfigServerName(), false, null);
        List configServerList = (List)response.getValue();
        if (configServerList.size() == 0) {
            throw new RuntimeException("No instances : " + env.getConfigServerName());
        }
        HealthService healthService = (HealthService)configServerList.get(0);
        String ip = healthService.getService().getAddress();
        String port = healthService.getService().getPort().toString();
        return "http://" + ip + ":" + port + env.getContextPath();
    }

    public List<String> allConfigServerBaseUrl(String envName) {
        ArrayList<String> result = new ArrayList<String>();
        Env env = this.envRepo.findByName(envName);
        if (env.getRegistryAddress() == null || env.getRegistryAddress().isEmpty()) {
            result.add(env.getConfigServerName() + env.getContextPath());
            return result;
        }
        ConsulClient consulClient = new ConsulClient(env.getRegistryAddress());
        Response response = consulClient.getHealthServices(env.getConfigServerName(), false, null);
        List configServerList = (List)response.getValue();
        for (HealthService healthService : configServerList) {
            String ip = healthService.getService().getAddress();
            String port = healthService.getService().getPort().toString();
            result.add("http://" + ip + ":" + port + env.getContextPath());
        }
        return result;
    }
}

