/*
 * Decompiled with CFR 0.152.
 */
package com.didispace.scca.service.discovery.eureka;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.didispace.scca.core.domain.Env;
import com.didispace.scca.core.service.impl.BaseUrlMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class UrlMaker4Eureka
extends BaseUrlMaker {
    private static final Logger log = LoggerFactory.getLogger(UrlMaker4Eureka.class);
    private String getInstantsUrl = "/apps/{serviceName}";
    private RestTemplate restTemplate = new RestTemplate();

    public String configServerBaseUrl(String envName) {
        Env env = this.envRepo.findByName(envName);
        if (env.getRegistryAddress() == null || env.getRegistryAddress().isEmpty()) {
            return super.configServerBaseUrl(envName);
        }
        String url = env.getRegistryAddress() + this.getInstantsUrl.replace("{serviceName}", env.getConfigServerName());
        url = url.replaceAll("//", "/").replaceFirst(":/", "://");
        log.info("Get config server instances url : " + url);
        String rStr = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
        JSONObject response = JSON.parseObject((String)rStr);
        String homePageUrl = null;
        for (Object o : response.getJSONObject("application").getJSONArray("instance")) {
            Map instance = (Map)o;
            if (!((String)instance.get("status")).equals("UP")) continue;
            homePageUrl = (String)instance.get("homePageUrl");
        }
        if (homePageUrl == null) {
            throw new RuntimeException("No instances : " + env.getConfigServerName());
        }
        if (homePageUrl.lastIndexOf("/") + 1 == homePageUrl.length() && env.getContextPath() != null && env.getContextPath().indexOf("/") == 0) {
            homePageUrl = homePageUrl.substring(0, homePageUrl.length() - 1);
        }
        return homePageUrl + env.getContextPath();
    }

    public List<String> allConfigServerBaseUrl(String envName) {
        ArrayList<String> result = new ArrayList<String>();
        Env env = this.envRepo.findByName(envName);
        if (env.getRegistryAddress() == null || env.getRegistryAddress().isEmpty()) {
            result.add(env.getConfigServerName() + env.getContextPath());
            return result;
        }
        String url = env.getRegistryAddress() + this.getInstantsUrl.replace("{serviceName}", env.getConfigServerName());
        url = url.replaceAll("//", "/").replaceFirst(":/", "://");
        log.info("Get config server instances url : " + url);
        String rStr = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
        JSONObject response = JSON.parseObject((String)rStr);
        for (Object o : response.getJSONObject("application").getJSONArray("instance")) {
            Map instance = (Map)o;
            if (!((String)instance.get("status")).equals("UP")) continue;
            String homePageUrl = (String)instance.get("homePageUrl");
            if (homePageUrl.lastIndexOf("/") + 1 == homePageUrl.length() && env.getContextPath() != null && env.getContextPath().indexOf("/") == 0) {
                homePageUrl = homePageUrl.substring(0, homePageUrl.length() - 1);
            }
            result.add(homePageUrl + env.getContextPath());
        }
        return result;
    }
}

