/*
 * Decompiled with CFR 0.152.
 */
package com.didispace.scca.service.persistence.git;

import com.didispace.scca.core.domain.Env;
import com.didispace.scca.core.domain.EnvRepo;
import com.didispace.scca.core.domain.Label;
import com.didispace.scca.core.domain.Project;
import com.didispace.scca.core.domain.ProjectRepo;
import com.didispace.scca.core.service.PersistenceService;
import com.didispace.scca.core.service.UrlMakerService;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class GitPersistenceService
implements PersistenceService {
    private static final Logger log = LoggerFactory.getLogger(GitPersistenceService.class);
    @Autowired
    private EnvRepo envRepo;
    @Autowired
    private ProjectRepo projectRepo;
    @Autowired
    private UrlMakerService urlMakerService;
    private RestTemplate restTemplate = new RestTemplate();

    public Properties readProperties(String application, String profile, String label) {
        String url = this.urlMakerService.configServerBaseUrl(profile) + "/readProperties?application={1}&profile={2}&label={3}";
        Properties properties = (Properties)this.restTemplate.getForObject(url, Properties.class, new Object[]{application, profile, label});
        return properties;
    }

    public void deletePropertiesByEnv(String profile) {
        Env env = this.envRepo.findByName(profile);
        for (Project project : env.getProjects()) {
            for (Label label : project.getLabels()) {
                this.deletePropertiesByProjectAndEnvAndLabel(project.getName(), env.getName(), label.getName());
            }
        }
    }

    public void deletePropertiesByProject(String application) {
        Project project = this.projectRepo.findByName(application);
        for (Env env : project.getEnvs()) {
            for (Label label : project.getLabels()) {
                this.deletePropertiesByProjectAndEnvAndLabel(project.getName(), env.getName(), label.getName());
            }
        }
    }

    public void deletePropertiesByProjectAndEnv(String application, String profile) {
        Project project = this.projectRepo.findByName(application);
        for (Label label : project.getLabels()) {
            this.deletePropertiesByProjectAndEnvAndLabel(project.getName(), profile, label.getName());
        }
    }

    public void deletePropertiesByLabel(Label label) {
        String projectName = label.getProject().getName();
        for (Env env : label.getProject().getEnvs()) {
            this.deletePropertiesByProjectAndEnvAndLabel(projectName, env.getName(), label.getName());
        }
    }

    public void deletePropertiesByProjectAndEnvAndLabel(String application, String profile, String label) {
        String url = this.urlMakerService.configServerBaseUrl(profile) + "/deletePropertiesByProjectAndEnvAndLabel?application={1}&profile={2}&label={3}";
        String result = (String)this.restTemplate.getForObject(url, String.class, new Object[]{application, profile, label});
        log.info("delete {}-{}-{} property {}", new Object[]{application, profile, label, result});
    }

    public void saveProperties(String application, String profile, String label, Properties update) {
        String url = this.urlMakerService.configServerBaseUrl(profile) + "/saveProperties?application={1}&profile={2}&label={3}";
        String result = (String)this.restTemplate.postForObject(url, (Object)update, String.class, new Object[]{application, profile, label});
        log.info("add {}-{}-{} property {}", new Object[]{application, profile, label, result});
    }

    public void updateProfileName(String oldName, String newName) {
    }
}

