/*
 * Decompiled with CFR 0.152.
 */
package com.didispace.scca.plugin.db;

import com.didispace.scca.plugin.db.Property;
import com.didispace.scca.plugin.db.PropertyRepo;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${spring.cloud.config.server.prefix:}"})
public class DbPropertyController {
    private static final Logger log = LoggerFactory.getLogger(DbPropertyController.class);
    @Autowired
    private PropertyRepo propertyRepo;

    @RequestMapping(path={"/readProperties"}, method={RequestMethod.GET})
    public Properties readProperties(@RequestParam String application, @RequestParam String profile, @RequestParam String label) {
        Properties properties = new Properties();
        for (Property property : this.propertyRepo.findAllByApplicationAndProfileAndLabel(application, profile, label)) {
            properties.put(property.getPKey(), property.getPValue());
        }
        return properties;
    }

    @Transactional
    @RequestMapping(path={"/deletePropertiesByEnv"}, method={RequestMethod.GET})
    public int deletePropertiesByEnv(@RequestParam String profile) {
        int rows = this.propertyRepo.deleteAllByProfile(profile);
        log.info("delete env [{}] property rows {}", (Object)profile, (Object)rows);
        return rows;
    }

    @Transactional
    @RequestMapping(path={"/deletePropertiesByProject"}, method={RequestMethod.GET})
    public int deletePropertiesByProject(@RequestParam String application) {
        int rows = this.propertyRepo.deleteAllByApplication(application);
        log.info("delete project [{}] property rows {}", (Object)application, (Object)rows);
        return rows;
    }

    @Transactional
    @RequestMapping(path={"/deletePropertiesByProjectAndEnv"}, method={RequestMethod.GET})
    public int deletePropertiesByProjectAndEnv(@RequestParam String application, @RequestParam String profile) {
        int rows = this.propertyRepo.deleteAllByApplicationAndProfile(application, profile);
        log.info("delete project [{}] in env [{}] property rows {}", new Object[]{application, profile, rows});
        return rows;
    }

    @Transactional
    @RequestMapping(path={"/deletePropertiesByLabel"}, method={RequestMethod.GET})
    public int deletePropertiesByLabel(@RequestParam String label) {
        int rows = 0;
        return rows;
    }

    @Transactional
    @RequestMapping(path={"/deletePropertiesByProjectAndEnvAndLabel"}, method={RequestMethod.GET})
    public int deletePropertiesByProjectAndEnvAndLabel(@RequestParam String application, @RequestParam String profile, @RequestParam String label) {
        int rows = this.propertyRepo.deleteAllByApplicationAndProfileAndLabel(application, profile, label);
        log.info("delete {}-{}-{} property rows {}", new Object[]{application, profile, label, rows});
        return rows;
    }

    @Transactional
    @RequestMapping(path={"/saveProperties"}, method={RequestMethod.POST})
    public int saveProperties(@RequestParam String application, @RequestParam String profile, @RequestParam String label, @RequestBody Properties update) {
        int rows = this.propertyRepo.deleteAllByApplicationAndProfileAndLabel(application, profile, label);
        log.info("delete {}-{}-{} property rows {}", new Object[]{application, profile, label, rows});
        for (String name : update.stringPropertyNames()) {
            Property property = new Property();
            property.setPKey(name);
            property.setPValue(update.getProperty(name));
            property.setProfile(profile);
            property.setApplication(application);
            property.setLabel(label);
            this.propertyRepo.save(property);
        }
        log.info("add {}-{}-{} rows {}", new Object[]{application, profile, label, update.size()});
        return rows;
    }

    @Transactional
    @RequestMapping(path={"/updateProfileName"}, method={RequestMethod.GET})
    public int updateProfileName(@RequestParam String oldName, @RequestParam String newName) {
        int rows = this.propertyRepo.updateProfileName(newName, oldName);
        log.info("update profile name {} -> {}, change property rows {}", new Object[]{oldName, newName, rows});
        return rows;
    }
}

