/*
 * Decompiled with CFR 0.152.
 */
package com.didispace.swagger.butler;

import com.didispace.swagger.butler.SwaggerResourceProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="swagger.butler")
public class SwaggerButlerProperties {
    private Map<String, SwaggerResourceProperties> resources = new HashMap<String, SwaggerResourceProperties>();
    private Boolean notShowNoInstanceService = true;
    private String apiDocsPath = "/v2/api-docs";
    private String swaggerVersion = "2.0";
    private Boolean autoGenerateFromZuulRoutes = false;
    private Set<String> ignoreRoutes = new HashSet<String>();
    private Set<String> generateRoutes = new HashSet<String>();

    public boolean needIgnore(String route) {
        if (this.generateRoutes.size() > 0 && this.ignoreRoutes.size() > 0) {
            throw new RuntimeException("generateRoutes\u548cignoreRoutes\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a");
        }
        if (this.generateRoutes.size() == 0 && this.ignoreRoutes.size() == 0) {
            return false;
        }
        if (this.generateRoutes.size() == 0 && this.ignoreRoutes.contains(route)) {
            return true;
        }
        return this.ignoreRoutes.size() == 0 && !this.generateRoutes.contains(route);
    }

    public Map<String, SwaggerResourceProperties> getResources() {
        return this.resources;
    }

    public Boolean getNotShowNoInstanceService() {
        return this.notShowNoInstanceService;
    }

    public String getApiDocsPath() {
        return this.apiDocsPath;
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public Boolean getAutoGenerateFromZuulRoutes() {
        return this.autoGenerateFromZuulRoutes;
    }

    public Set<String> getIgnoreRoutes() {
        return this.ignoreRoutes;
    }

    public Set<String> getGenerateRoutes() {
        return this.generateRoutes;
    }

    public void setResources(Map<String, SwaggerResourceProperties> resources) {
        this.resources = resources;
    }

    public void setNotShowNoInstanceService(Boolean notShowNoInstanceService) {
        this.notShowNoInstanceService = notShowNoInstanceService;
    }

    public void setApiDocsPath(String apiDocsPath) {
        this.apiDocsPath = apiDocsPath;
    }

    public void setSwaggerVersion(String swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    public void setAutoGenerateFromZuulRoutes(Boolean autoGenerateFromZuulRoutes) {
        this.autoGenerateFromZuulRoutes = autoGenerateFromZuulRoutes;
    }

    public void setIgnoreRoutes(Set<String> ignoreRoutes) {
        this.ignoreRoutes = ignoreRoutes;
    }

    public void setGenerateRoutes(Set<String> generateRoutes) {
        this.generateRoutes = generateRoutes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwaggerButlerProperties)) {
            return false;
        }
        SwaggerButlerProperties other = (SwaggerButlerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, SwaggerResourceProperties> this$resources = this.getResources();
        Map<String, SwaggerResourceProperties> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Boolean this$notShowNoInstanceService = this.getNotShowNoInstanceService();
        Boolean other$notShowNoInstanceService = other.getNotShowNoInstanceService();
        if (this$notShowNoInstanceService == null ? other$notShowNoInstanceService != null : !((Object)this$notShowNoInstanceService).equals(other$notShowNoInstanceService)) {
            return false;
        }
        String this$apiDocsPath = this.getApiDocsPath();
        String other$apiDocsPath = other.getApiDocsPath();
        if (this$apiDocsPath == null ? other$apiDocsPath != null : !this$apiDocsPath.equals(other$apiDocsPath)) {
            return false;
        }
        String this$swaggerVersion = this.getSwaggerVersion();
        String other$swaggerVersion = other.getSwaggerVersion();
        if (this$swaggerVersion == null ? other$swaggerVersion != null : !this$swaggerVersion.equals(other$swaggerVersion)) {
            return false;
        }
        Boolean this$autoGenerateFromZuulRoutes = this.getAutoGenerateFromZuulRoutes();
        Boolean other$autoGenerateFromZuulRoutes = other.getAutoGenerateFromZuulRoutes();
        if (this$autoGenerateFromZuulRoutes == null ? other$autoGenerateFromZuulRoutes != null : !((Object)this$autoGenerateFromZuulRoutes).equals(other$autoGenerateFromZuulRoutes)) {
            return false;
        }
        Set<String> this$ignoreRoutes = this.getIgnoreRoutes();
        Set<String> other$ignoreRoutes = other.getIgnoreRoutes();
        if (this$ignoreRoutes == null ? other$ignoreRoutes != null : !((Object)this$ignoreRoutes).equals(other$ignoreRoutes)) {
            return false;
        }
        Set<String> this$generateRoutes = this.getGenerateRoutes();
        Set<String> other$generateRoutes = other.getGenerateRoutes();
        return !(this$generateRoutes == null ? other$generateRoutes != null : !((Object)this$generateRoutes).equals(other$generateRoutes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwaggerButlerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, SwaggerResourceProperties> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Boolean $notShowNoInstanceService = this.getNotShowNoInstanceService();
        result = result * 59 + ($notShowNoInstanceService == null ? 43 : ((Object)$notShowNoInstanceService).hashCode());
        String $apiDocsPath = this.getApiDocsPath();
        result = result * 59 + ($apiDocsPath == null ? 43 : $apiDocsPath.hashCode());
        String $swaggerVersion = this.getSwaggerVersion();
        result = result * 59 + ($swaggerVersion == null ? 43 : $swaggerVersion.hashCode());
        Boolean $autoGenerateFromZuulRoutes = this.getAutoGenerateFromZuulRoutes();
        result = result * 59 + ($autoGenerateFromZuulRoutes == null ? 43 : ((Object)$autoGenerateFromZuulRoutes).hashCode());
        Set<String> $ignoreRoutes = this.getIgnoreRoutes();
        result = result * 59 + ($ignoreRoutes == null ? 43 : ((Object)$ignoreRoutes).hashCode());
        Set<String> $generateRoutes = this.getGenerateRoutes();
        result = result * 59 + ($generateRoutes == null ? 43 : ((Object)$generateRoutes).hashCode());
        return result;
    }

    public String toString() {
        return "SwaggerButlerProperties(resources=" + this.getResources() + ", notShowNoInstanceService=" + this.getNotShowNoInstanceService() + ", apiDocsPath=" + this.getApiDocsPath() + ", swaggerVersion=" + this.getSwaggerVersion() + ", autoGenerateFromZuulRoutes=" + this.getAutoGenerateFromZuulRoutes() + ", ignoreRoutes=" + this.getIgnoreRoutes() + ", generateRoutes=" + this.getGenerateRoutes() + ")";
    }
}

