/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm;

import com.dieselpoint.norm.DbException;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;

public class Transaction
implements Closeable {
    private Connection con;

    void setConnection(Connection con) {
        this.con = con;
        try {
            con.setAutoCommit(false);
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
    }

    public void commit() {
        try {
            this.con.commit();
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
        finally {
            try {
                this.con.close();
            }
            catch (Throwable t) {
                throw new DbException(t);
            }
        }
    }

    public void rollback() {
        try {
            this.con.rollback();
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
        finally {
            try {
                this.con.close();
            }
            catch (Throwable t) {
                throw new DbException(t);
            }
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    @Override
    public void close() throws IOException {
        this.commit();
    }
}

