/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.converter;

import com.dieselpoint.norm.DbException;
import com.dieselpoint.norm.converter.SimpleArray;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class IntArrayToListConverter
implements AttributeConverter<List<Integer>, Array> {
    public Array convertToDatabaseColumn(List<Integer> attribute) {
        return new SimpleArray(4, attribute.toArray());
    }

    public List<Integer> convertToEntityAttribute(Array dbData) {
        try {
            if (dbData.getBaseType() != 4) {
                throw new DbException("Database is not returning an integer array");
            }
            Integer[] arr = (Integer[])dbData.getArray();
            ArrayList<Integer> out = new ArrayList<Integer>();
            for (Integer i : arr) {
                out.add(i);
            }
            return out;
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }
}

