/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.sqlmakers;

import com.dieselpoint.norm.sqlmakers.PojoInfo;
import com.dieselpoint.norm.sqlmakers.Property;
import com.dieselpoint.norm.sqlmakers.StandardPojoInfo;
import com.dieselpoint.norm.sqlmakers.StandardSqlMaker;
import javax.persistence.Column;

public class PostgresMaker
extends StandardSqlMaker {
    @Override
    public String getCreateTableSql(Class<?> clazz) {
        StringBuilder buf = new StringBuilder();
        PojoInfo pojoInfo = this.getPojoInfo((Class)clazz);
        buf.append("create table ");
        buf.append(((StandardPojoInfo)pojoInfo).table);
        buf.append(" (");
        boolean needsComma = false;
        for (Property prop : ((StandardPojoInfo)pojoInfo).propertyMap.values()) {
            if (needsComma) {
                buf.append(',');
            }
            needsComma = true;
            Column columnAnnot = prop.columnAnnotation;
            if (columnAnnot == null) {
                buf.append(prop.name);
                buf.append(" ");
                if (prop.isGenerated) {
                    buf.append(" serial");
                    continue;
                }
                buf.append(this.getColType(prop.dataType, 255, 10, 2));
                continue;
            }
            if (columnAnnot.columnDefinition() == null) {
                buf.append(columnAnnot.columnDefinition());
                continue;
            }
            buf.append(prop.name);
            buf.append(" ");
            if (prop.isGenerated) {
                buf.append(" serial");
            } else {
                buf.append(this.getColType(prop.dataType, columnAnnot.length(), columnAnnot.precision(), columnAnnot.scale()));
            }
            if (columnAnnot.unique()) {
                buf.append(" unique");
            }
            if (columnAnnot.nullable()) continue;
            buf.append(" not null");
        }
        if (((StandardPojoInfo)pojoInfo).primaryKeyName != null) {
            buf.append(", primary key (");
            buf.append(((StandardPojoInfo)pojoInfo).primaryKeyName);
            buf.append(")");
        }
        buf.append(")");
        return buf.toString();
    }
}

