/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.sqlmakers;

import com.dieselpoint.norm.ColumnOrder;
import com.dieselpoint.norm.DbException;
import com.dieselpoint.norm.serialize.DbSerializer;
import com.dieselpoint.norm.sqlmakers.PojoInfo;
import com.dieselpoint.norm.sqlmakers.Property;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

public class StandardPojoInfo
implements PojoInfo {
    public LinkedHashMap<String, Property> propertyMap = new LinkedHashMap();
    public String table;
    public String primaryKeyName;
    public String generatedColumnName;
    public String insertSql;
    public int insertSqlArgCount;
    public String[] insertColumnNames;
    public String upsertSql;
    public int upsertSqlArgCount;
    public String[] upsertColumnNames;
    public String updateSql;
    public String[] updateColumnNames;
    public int updateSqlArgCount;
    public String selectColumns;

    public StandardPojoInfo(Class<?> clazz) {
        try {
            if (!Map.class.isAssignableFrom(clazz)) {
                List<Property> props = this.populateProperties(clazz);
                ColumnOrder colOrder = clazz.getAnnotation(ColumnOrder.class);
                if (colOrder != null) {
                    String[] cols = colOrder.value();
                    ArrayList<Property> reordered = new ArrayList<Property>();
                    block2: for (int i = 0; i < cols.length; ++i) {
                        for (Property prop : props) {
                            if (!prop.name.equals(cols[i])) continue;
                            reordered.add(prop);
                            continue block2;
                        }
                    }
                    props = reordered;
                }
                for (Property prop : props) {
                    this.propertyMap.put(prop.name, prop);
                }
            }
            Table annot = clazz.getAnnotation(Table.class);
            this.table = annot != null ? (annot.schema() != null && !annot.schema().isEmpty() ? annot.schema() + "." + annot.name() : annot.name()) : clazz.getSimpleName();
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
    }

    private List<Property> populateProperties(Class<?> clazz) throws IntrospectionException, InstantiationException, IllegalAccessException {
        PropertyDescriptor[] descriptors;
        ArrayList<Property> props = new ArrayList<Property>();
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || field.getAnnotation(Transient.class) != null) continue;
            Property prop = new Property();
            prop.name = field.getName();
            prop.field = field;
            prop.dataType = field.getType();
            this.applyAnnotations(prop, field);
            props.add(prop);
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || readMethod.getAnnotation(Transient.class) != null) continue;
            Property prop = new Property();
            prop.name = descriptor.getName();
            prop.readMethod = readMethod;
            prop.writeMethod = descriptor.getWriteMethod();
            prop.dataType = descriptor.getPropertyType();
            this.applyAnnotations(prop, prop.readMethod);
            props.add(prop);
        }
        return props;
    }

    private void applyAnnotations(Property prop, AnnotatedElement ae) throws InstantiationException, IllegalAccessException {
        Convert c;
        DbSerializer sc;
        Column col = ae.getAnnotation(Column.class);
        if (col != null) {
            String name = col.name().trim();
            if (name.length() > 0) {
                prop.name = name;
            }
            prop.columnAnnotation = col;
        }
        if (ae.getAnnotation(Id.class) != null) {
            prop.isPrimaryKey = true;
            this.primaryKeyName = prop.name;
        }
        if (ae.getAnnotation(GeneratedValue.class) != null) {
            this.generatedColumnName = prop.name;
            prop.isGenerated = true;
        }
        if (prop.dataType.isEnum()) {
            prop.isEnumField = true;
            prop.enumClass = prop.dataType;
            prop.enumType = EnumType.STRING;
            if (ae.getAnnotation(Enumerated.class) != null) {
                prop.enumType = ae.getAnnotation(Enumerated.class).value();
            }
        }
        if ((sc = ae.getAnnotation(DbSerializer.class)) != null) {
            prop.serializer = sc.value().newInstance();
        }
        if ((c = ae.getAnnotation(Convert.class)) != null) {
            prop.converter = (AttributeConverter)c.converter().newInstance();
        }
    }

    @Override
    public Object getValue(Object pojo, String name) {
        try {
            Property prop = this.propertyMap.get(name);
            if (prop == null) {
                throw new DbException("No such field: " + name);
            }
            Object value = null;
            if (prop.readMethod != null) {
                value = prop.readMethod.invoke(pojo, new Object[0]);
            } else if (prop.field != null) {
                value = prop.field.get(pojo);
            }
            if (value != null) {
                if (prop.serializer != null) {
                    value = prop.serializer.serialize(value);
                } else if (prop.converter != null) {
                    value = prop.converter.convertToDatabaseColumn(value);
                } else if (prop.isEnumField) {
                    value = prop.enumType == EnumType.ORDINAL ? Integer.valueOf(((Enum)value).ordinal()) : value.toString();
                }
            }
            return value;
        }
        catch (Throwable t) {
            throw new DbException(t);
        }
    }

    @Override
    public void putValue(Object pojo, String name, Object value) {
        this.putValue(pojo, name, value, false);
    }

    @Override
    public void putValue(Object pojo, String name, Object value, boolean ignoreIfMissing) {
        Property prop = this.propertyMap.get(name);
        if (prop == null) {
            if (ignoreIfMissing) {
                return;
            }
            throw new DbException("No such field: " + name);
        }
        if (value != null) {
            if (prop.serializer != null) {
                value = prop.serializer.deserialize((String)value, prop.dataType);
            } else if (prop.converter != null) {
                value = prop.converter.convertToEntityAttribute(value);
            } else if (prop.isEnumField) {
                value = this.getEnumConst(prop.enumClass, prop.enumType, value);
            }
        }
        if (prop.writeMethod != null) {
            try {
                prop.writeMethod.invoke(pojo, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new DbException("Could not write value into pojo. Property: " + prop.name + " method: " + prop.writeMethod.toString() + " value: " + value + " value class: " + value.getClass().toString(), e);
            }
            return;
        }
        if (prop.field != null) {
            try {
                prop.field.set(pojo, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new DbException("Could not set value into pojo. Field: " + prop.field.toString() + " value: " + value, e);
            }
            return;
        }
    }

    private <T extends Enum<T>> Object getEnumConst(Class<T> enumType, EnumType type, Object value) {
        String str = value.toString();
        if (type == EnumType.ORDINAL) {
            Integer ordinalValue = (Integer)value;
            if (ordinalValue < 0 || ordinalValue >= ((Enum[])enumType.getEnumConstants()).length) {
                throw new DbException("Invalid ordinal number " + ordinalValue + " for enum class " + enumType.getCanonicalName());
            }
            return ((Enum[])enumType.getEnumConstants())[ordinalValue];
        }
        for (Enum e : (Enum[])enumType.getEnumConstants()) {
            if (!str.equals(e.toString())) continue;
            return e;
        }
        throw new DbException("Enum value does not exist. value:" + str);
    }

    @Override
    public Property getGeneratedColumnProperty() {
        return this.propertyMap.get(this.generatedColumnName);
    }

    @Override
    public Property getProperty(String name) {
        return this.propertyMap.get(name);
    }
}

