/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.globals;

import com.diffplug.common.globals.GlobalsDev;
import com.diffplug.common.globals.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;

public class TimeDev
extends Time {
    private volatile long now;

    protected synchronized long getNow() {
        return this.now;
    }

    public static TimeDev install() {
        return GlobalsDev.install(Time.class, new TimeDev());
    }

    private TimeDev() {
    }

    public synchronized void set(long to) {
        this.now = to;
    }

    public synchronized void set(ZonedDateTime zoneDateTime) {
        this.set(zoneDateTime.toEpochSecond() * 1000L + (long)(zoneDateTime.getNano() / 1000));
    }

    public synchronized void setUTC(LocalDateTime localDate) {
        this.set(localDate.atZone(ZoneOffset.UTC));
    }

    public synchronized void setUTC(LocalDate localDate) {
        this.setUTC(localDate.atStartOfDay());
    }

    public synchronized void add(TimeUnit unit, long delta) {
        this.now += unit.toMillis(delta);
    }
}

