/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.tree;

import com.diffplug.common.tree.TreeDef;
import com.diffplug.common.tree.TreeQuery;
import com.diffplug.common.tree.TreeStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TreeNode<T> {
    @Nullable
    private TreeNode<T> parent;
    private T content;
    private List<TreeNode<T>> children;
    private static final TreeDef.Parented TREE_DEF = new TreeDef.Parented<TreeNode<Object>>(){

        @Override
        public List<TreeNode<Object>> childrenOf(TreeNode<Object> root) {
            return root.getChildren();
        }

        @Override
        public TreeNode<Object> parentOf(TreeNode<Object> child) {
            return ((TreeNode)child).parent;
        }
    };

    public TreeNode(@Nullable TreeNode<T> parent, T content) {
        this(parent, content, 0);
    }

    public TreeNode(@Nullable TreeNode<T> parent, T content, int childCapacity) {
        this.parent = parent;
        this.content = Objects.requireNonNull(content);
        this.setParent(parent);
        this.children = childCapacity == 0 ? Collections.EMPTY_LIST : new ArrayList<TreeNode<T>>(childCapacity);
    }

    public T getContent() {
        return this.content;
    }

    public void setContent(T content) {
        this.content = Objects.requireNonNull(content);
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public List<TreeNode<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void removeFromParent() {
        this.setParent(null);
    }

    public void setParent(@Nullable TreeNode<T> parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            if (parent.children == Collections.EMPTY_LIST) {
                parent.children = new ArrayList<TreeNode<T>>();
            }
            parent.children.add(this);
        }
    }

    public String toString() {
        return "TreeNode[" + this.content + "]";
    }

    public String getPath() {
        return this.getPath(Object::toString);
    }

    public String getPath(Function<? super T, String> toString) {
        return this.getPath(toString, "/");
    }

    public String getPath(Function<? super T, String> toString, String delimiter) {
        Objects.requireNonNull(toString);
        Objects.requireNonNull(delimiter);
        return TreeQuery.path(TreeNode.treeDef(), this, node -> (String)toString.apply((Object)node.getContent()), delimiter);
    }

    public String toStringDeep() {
        return TreeQuery.toString(TreeNode.treeDef(), this, node -> node.getContent().toString());
    }

    public TreeNode<T> copy() {
        return TreeNode.copy(TreeNode.treeDef(), this, TreeNode::getContent);
    }

    public void sortChildrenByContent(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        Comparator<TreeNode<T>> byContent = Comparator.comparing(TreeNode::getContent, comparator);
        this.sortChildrenByNode(byContent);
    }

    public void sortChildrenByNode(Comparator<TreeNode<T>> comparator) {
        Objects.requireNonNull(comparator);
        Collections.sort(this.children, comparator);
        for (TreeNode<T> child : this.children) {
            child.sortChildrenByNode(comparator);
        }
    }

    public static <T> TreeNode<T> copy(TreeDef<T> treeDef, T root) {
        return TreeNode.copy(treeDef, root, Function.identity());
    }

    public static <T, R> TreeNode<R> copy(TreeDef<T> treeDef, T root, Function<? super T, ? extends R> mapper) {
        List<T> children = treeDef.childrenOf(root);
        R mapped = mapper.apply(root);
        TreeNode<R> copyRoot = new TreeNode<R>(null, mapped, children.size());
        TreeNode.copyRecurse(copyRoot, treeDef, root, children, mapper);
        return copyRoot;
    }

    private static <T, R> void copyRecurse(TreeNode<R> copiedRoot, TreeDef<T> treeDef, T root, List<T> children, Function<? super T, ? extends R> mapper) {
        for (T child : children) {
            R mapped = mapper.apply(child);
            List<T> grandChildren = treeDef.childrenOf(child);
            TreeNode.copyRecurse(new TreeNode<R>(copiedRoot, mapped, grandChildren.size()), treeDef, child, grandChildren, mapper);
        }
    }

    public static <T> TreeDef.Parented<TreeNode<T>> treeDef() {
        return TREE_DEF;
    }

    public static TreeNode<String> createTestData(String ... testData) {
        TreeNode<String> rootNode;
        List<String> test = Arrays.asList(testData);
        assert (test.size() > 0);
        assert (0 == TreeNode.leadingSpaces(test.get(0)));
        TreeNode<String> lastNode = rootNode = new TreeNode<String>(null, test.get(0));
        int lastSpaces = 0;
        for (int i = 1; i < test.size(); ++i) {
            int newSpaces = TreeNode.leadingSpaces(test.get(i));
            String name = test.get(i).substring(newSpaces);
            if (newSpaces == lastSpaces + 1) {
                lastNode = new TreeNode<String>(lastNode, name);
                lastSpaces = newSpaces;
                continue;
            }
            if (newSpaces <= lastSpaces) {
                TreeNode<String> properParent = lastNode.getParent();
                int diff = lastSpaces - newSpaces;
                for (int j = 0; j < diff; ++j) {
                    properParent = properParent.getParent();
                }
                lastNode = new TreeNode<String>(properParent, name);
                lastSpaces = newSpaces;
                continue;
            }
            throw new IllegalArgumentException("Last element \"" + test.get(i - 1) + "\"" + " and this element \"" + test.get(i) + "\" have too many spaces between them.");
        }
        return rootNode;
    }

    private static int leadingSpaces(String name) {
        int i;
        for (i = 0; i < name.length() && name.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    public TreeNode<T> findByPath(T ... path) {
        return this.findByPath(Arrays.asList(path));
    }

    public TreeNode<T> findByPath(List<T> path) {
        Optional<TreeNode> result = TreeQuery.findByPath(TreeNode.treeDef(), this, TreeNode::getContent, path, Function.identity());
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException(this.toString() + " has no element with path " + path);
    }

    public TreeNode<T> findByContent(T content) {
        Objects.requireNonNull(content);
        Optional<TreeNode> opt = TreeStream.breadthFirst(TreeNode.treeDef(), this).filter(node -> node.getContent().equals(content)).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        throw new IllegalArgumentException(this.toString() + " has no child with content " + content);
    }
}

