/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.util.concurrent;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.ImmutableCollection;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.Lists;
import com.diffplug.common.util.concurrent.AggregateFuture;
import com.diffplug.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@GwtCompatible
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed, true);
            this.values = futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity((int)futures.size());
            for (int i = 0; i < futures.size(); ++i) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean allMustSucceed, int index, @Nullable V returnValue) {
            List localValues = this.values;
            if (localValues != null) {
                localValues.set(index, Optional.ofNullable(returnValue));
            } else {
                Preconditions.checkState((allMustSucceed || CollectionFuture.this.isCancelled() ? 1 : 0) != 0, (Object)"Future was done before all dependencies completed");
            }
        }

        @Override
        final void handleAllCompleted() {
            List localValues = this.values;
            if (localValues != null) {
                CollectionFuture.this.set(this.combine(localValues));
            } else {
                Preconditions.checkState((boolean)CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }

        abstract C combine(List<Optional<V>> var1);
    }
}

