/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.swt.os;

import com.diffplug.common.swt.os.OS;

public enum Arch {
    x86,
    x64;


    public <T> T x86x64(T val86, T val64) {
        switch (this) {
            case x86: {
                return val86;
            }
            case x64: {
                return val64;
            }
        }
        throw Arch.unsupportedException(this);
    }

    public static Arch getNative() {
        return OS.getNative().getArch();
    }

    public static Arch getRunning() {
        return OS.getRunning().getArch();
    }

    public static UnsupportedOperationException unsupportedException(Arch arch) {
        return new UnsupportedOperationException("Arch '" + (Object)((Object)arch) + "' is unsupported.");
    }
}

