/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.swt.os;

import com.diffplug.common.swt.os.OS;

public enum WS {
    WIN,
    COCOA,
    GTK;

    private static final WS RUNNING_WS;

    public boolean isWin() {
        return this == WIN;
    }

    public boolean isCocoa() {
        return this == COCOA;
    }

    public boolean isGTK() {
        return this == GTK;
    }

    public <T> T winCocoaGtk(T win, T cocoa, T gtk) {
        switch (this) {
            case WIN: {
                return win;
            }
            case COCOA: {
                return cocoa;
            }
            case GTK: {
                return gtk;
            }
        }
        throw WS.unsupportedException(this);
    }

    public static WS getRunning() {
        return RUNNING_WS;
    }

    public static UnsupportedOperationException unsupportedException(WS ws) {
        return new UnsupportedOperationException("Window system '" + (Object)((Object)ws) + "' is unsupported.");
    }

    static {
        RUNNING_WS = OS.getRunning().winMacLinux(WIN, COCOA, GTK);
    }
}

