/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing;

import com.diffplug.common.collect.testing.AbstractTester;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.Platform;
import com.diffplug.common.collect.testing.features.ConflictingRequirementsException;
import com.diffplug.common.collect.testing.features.Feature;
import com.diffplug.common.collect.testing.features.FeatureUtil;
import com.diffplug.common.collect.testing.features.TesterRequirements;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class FeatureSpecificTestSuiteBuilder<B extends FeatureSpecificTestSuiteBuilder<B, G>, G> {
    private G subjectGenerator;
    private Runnable setUp;
    private Runnable tearDown;
    private Set<Feature<?>> features = new LinkedHashSet();
    private String name;
    private Set<Method> suppressedTests = new HashSet<Method>();
    private static final Logger logger = Logger.getLogger(FeatureSpecificTestSuiteBuilder.class.getName());

    protected B self() {
        return (B)this;
    }

    protected B usingGenerator(G subjectGenerator) {
        this.subjectGenerator = subjectGenerator;
        return this.self();
    }

    public G getSubjectGenerator() {
        return this.subjectGenerator;
    }

    public B withSetUp(Runnable setUp) {
        this.setUp = setUp;
        return this.self();
    }

    protected Runnable getSetUp() {
        return this.setUp;
    }

    public B withTearDown(Runnable tearDown) {
        this.tearDown = tearDown;
        return this.self();
    }

    protected Runnable getTearDown() {
        return this.tearDown;
    }

    public B withFeatures(Feature<?> ... features) {
        return this.withFeatures(Arrays.asList(features));
    }

    public B withFeatures(Iterable<? extends Feature<?>> features) {
        for (Feature<?> feature : features) {
            this.features.add(feature);
        }
        return this.self();
    }

    public Set<Feature<?>> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    public B named(String name) {
        if (name.contains("(")) {
            throw new IllegalArgumentException("Eclipse hides all characters after '('; please use '[]' or other characters instead of parentheses");
        }
        this.name = name;
        return this.self();
    }

    public String getName() {
        return this.name;
    }

    public B suppressing(Method ... methods) {
        return this.suppressing(Arrays.asList(methods));
    }

    public B suppressing(Collection<Method> methods) {
        this.suppressedTests.addAll(methods);
        return this.self();
    }

    public Set<Method> getSuppressedTests() {
        return this.suppressedTests;
    }

    public TestSuite createTestSuite() {
        this.checkCanCreate();
        logger.fine(" Testing: " + this.name);
        logger.fine("Features: " + FeatureSpecificTestSuiteBuilder.formatFeatureSet(this.features));
        FeatureUtil.addImpliedFeatures(this.features);
        logger.fine("Expanded: " + FeatureSpecificTestSuiteBuilder.formatFeatureSet(this.features));
        List<Class<AbstractTester>> testers = this.getTesters();
        TestSuite suite = new TestSuite(this.name);
        for (Class<AbstractTester> testerClass : testers) {
            TestSuite testerSuite = this.makeSuiteForTesterClass(testerClass);
            if (testerSuite.countTestCases() <= 0) continue;
            suite.addTest((Test)testerSuite);
        }
        return suite;
    }

    protected void checkCanCreate() {
        if (this.subjectGenerator == null) {
            throw new IllegalStateException("Call using() before createTestSuite().");
        }
        if (this.name == null) {
            throw new IllegalStateException("Call named() before createTestSuite().");
        }
        if (this.features == null) {
            throw new IllegalStateException("Call withFeatures() before createTestSuite().");
        }
    }

    protected abstract List<Class<? extends AbstractTester>> getTesters();

    private boolean matches(Test test) {
        TesterRequirements requirements;
        Method method;
        try {
            method = FeatureSpecificTestSuiteBuilder.extractMethod(test);
        }
        catch (IllegalArgumentException e) {
            logger.finer(Platform.format("%s: including by default: %s", test, e.getMessage()));
            return true;
        }
        if (this.suppressedTests.contains(method)) {
            logger.finer(Platform.format("%s: excluding because it was explicitly suppressed.", test));
            return false;
        }
        try {
            requirements = FeatureUtil.getTesterRequirements(method);
        }
        catch (ConflictingRequirementsException e) {
            throw new RuntimeException(e);
        }
        if (!this.features.containsAll(requirements.getPresentFeatures())) {
            if (logger.isLoggable(Level.FINER)) {
                Set<Feature<Feature<?>>> missingFeatures = Helpers.copyToSet(requirements.getPresentFeatures());
                missingFeatures.removeAll(this.features);
                logger.finer(Platform.format("%s: skipping because these features are absent: %s", method, missingFeatures));
            }
            return false;
        }
        if (FeatureSpecificTestSuiteBuilder.intersect(this.features, requirements.getAbsentFeatures())) {
            if (logger.isLoggable(Level.FINER)) {
                Set<Feature<Feature<?>>> unwantedFeatures = Helpers.copyToSet(requirements.getAbsentFeatures());
                unwantedFeatures.retainAll(this.features);
                logger.finer(Platform.format("%s: skipping because these features are present: %s", method, unwantedFeatures));
            }
            return false;
        }
        return true;
    }

    private static boolean intersect(Set<?> a, Set<?> b) {
        return !Collections.disjoint(a, b);
    }

    private static Method extractMethod(Test test) {
        if (test instanceof AbstractTester) {
            AbstractTester tester = (AbstractTester)test;
            return Helpers.getMethod(((Object)((Object)tester)).getClass(), tester.getTestMethodName());
        }
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            return Helpers.getMethod(testCase.getClass(), testCase.getName());
        }
        throw new IllegalArgumentException("unable to extract method from test: not a TestCase.");
    }

    protected TestSuite makeSuiteForTesterClass(Class<? extends AbstractTester<?>> testerClass) {
        TestSuite candidateTests = new TestSuite(testerClass);
        TestSuite suite = this.filterSuite(candidateTests);
        Enumeration allTests = suite.tests();
        while (allTests.hasMoreElements()) {
            Object test = allTests.nextElement();
            if (!(test instanceof AbstractTester)) continue;
            AbstractTester tester = (AbstractTester)((Object)test);
            tester.init(this.subjectGenerator, this.name, this.setUp, this.tearDown);
        }
        return suite;
    }

    private TestSuite filterSuite(TestSuite suite) {
        TestSuite filtered = new TestSuite(suite.getName());
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (!this.matches(test)) continue;
            filtered.addTest(test);
        }
        return filtered;
    }

    protected static String formatFeatureSet(Set<? extends Feature<?>> features) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Feature<?> feature : features) {
            Feature<?> featureAsObject = feature;
            if (featureAsObject instanceof Enum) {
                Enum f = (Enum)((Object)featureAsObject);
                temp.add(f.getDeclaringClass().getSimpleName() + "." + feature);
                continue;
            }
            temp.add(feature.toString());
        }
        return ((Object)temp).toString();
    }
}

