/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing;

import com.diffplug.common.collect.testing.AbstractCollectionTestSuiteBuilder;
import com.diffplug.common.collect.testing.AbstractTester;
import com.diffplug.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.OneSizeTestContainerGenerator;
import com.diffplug.common.collect.testing.SampleElements;
import com.diffplug.common.collect.testing.TestListGenerator;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.Feature;
import com.diffplug.common.collect.testing.testers.CollectionSerializationEqualTester;
import com.diffplug.common.collect.testing.testers.ListAddAllAtIndexTester;
import com.diffplug.common.collect.testing.testers.ListAddAllTester;
import com.diffplug.common.collect.testing.testers.ListAddAtIndexTester;
import com.diffplug.common.collect.testing.testers.ListAddTester;
import com.diffplug.common.collect.testing.testers.ListCreationTester;
import com.diffplug.common.collect.testing.testers.ListEqualsTester;
import com.diffplug.common.collect.testing.testers.ListGetTester;
import com.diffplug.common.collect.testing.testers.ListHashCodeTester;
import com.diffplug.common.collect.testing.testers.ListIndexOfTester;
import com.diffplug.common.collect.testing.testers.ListLastIndexOfTester;
import com.diffplug.common.collect.testing.testers.ListListIteratorTester;
import com.diffplug.common.collect.testing.testers.ListRemoveAllTester;
import com.diffplug.common.collect.testing.testers.ListRemoveAtIndexTester;
import com.diffplug.common.collect.testing.testers.ListRemoveTester;
import com.diffplug.common.collect.testing.testers.ListRetainAllTester;
import com.diffplug.common.collect.testing.testers.ListSetTester;
import com.diffplug.common.collect.testing.testers.ListSubListTester;
import com.diffplug.common.collect.testing.testers.ListToArrayTester;
import com.diffplug.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

public final class ListTestSuiteBuilder<E>
extends AbstractCollectionTestSuiteBuilder<ListTestSuiteBuilder<E>, E> {
    public static <E> ListTestSuiteBuilder<E> using(TestListGenerator<E> generator) {
        return (ListTestSuiteBuilder)new ListTestSuiteBuilder<E>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(CollectionSerializationEqualTester.class);
        testers.add(ListAddAllAtIndexTester.class);
        testers.add(ListAddAllTester.class);
        testers.add(ListAddAtIndexTester.class);
        testers.add(ListAddTester.class);
        testers.add(ListCreationTester.class);
        testers.add(ListEqualsTester.class);
        testers.add(ListGetTester.class);
        testers.add(ListHashCodeTester.class);
        testers.add(ListIndexOfTester.class);
        testers.add(ListLastIndexOfTester.class);
        testers.add(ListListIteratorTester.class);
        testers.add(ListRemoveAllTester.class);
        testers.add(ListRemoveAtIndexTester.class);
        testers.add(ListRemoveTester.class);
        testers.add(ListRetainAllTester.class);
        testers.add(ListSetTester.class);
        testers.add(ListSubListTester.class);
        testers.add(ListToArrayTester.class);
        return testers;
    }

    @Override
    public TestSuite createTestSuite() {
        this.withFeatures(CollectionFeature.KNOWN_ORDER);
        return super.createTestSuite();
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using(new ReserializedListGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + " reserialized")).withFeatures(ListTestSuiteBuilder.computeReserializedCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        }
        return derivedSuites;
    }

    private static Set<Feature<?>> computeReserializedCollectionFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet();
        derivedFeatures.addAll(features);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    static class ReserializedListGenerator<E>
    implements TestListGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private ReserializedListGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public List<E> create(Object ... elements) {
            return (List)SerializableTester.reserialize(this.gen.create(elements));
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(insertionOrder);
        }
    }
}

