/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.Platform;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@GwtCompatible
public class MinimalCollection<E>
extends AbstractCollection<E> {
    private final E[] contents;
    private final Class<? super E> type;
    private final boolean allowNulls;

    public static <E> MinimalCollection<E> of(E ... contents) {
        return new MinimalCollection<Object>(Object.class, true, contents);
    }

    public static <E> MinimalCollection<E> ofClassAndContents(Class<? super E> type, E ... contents) {
        return new MinimalCollection<E>(type, true, contents);
    }

    MinimalCollection(Class<? super E> type, boolean allowNulls, E ... contents) {
        this.contents = Platform.clone(contents);
        this.type = type;
        this.allowNulls = allowNulls;
        if (!allowNulls) {
            for (E element : contents) {
                if (element != null) continue;
                throw new NullPointerException();
            }
        }
    }

    @Override
    public int size() {
        return this.contents.length;
    }

    @Override
    public boolean contains(Object object) {
        if (!this.allowNulls && object == null) {
            throw new NullPointerException();
        }
        Platform.checkCast(this.type, object);
        return Arrays.asList(this.contents).contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!this.allowNulls) {
            for (Object object : collection) {
                if (object != null) continue;
                throw new NullPointerException();
            }
        }
        return super.containsAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.contents).iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.contents.length];
        System.arraycopy(this.contents, 0, result, 0, this.contents.length);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> elementsToAdd) {
        throw MinimalCollection.up();
    }

    @Override
    public boolean removeAll(Collection<?> elementsToRemove) {
        throw MinimalCollection.up();
    }

    @Override
    public boolean retainAll(Collection<?> elementsToRetain) {
        throw MinimalCollection.up();
    }

    @Override
    public void clear() {
        throw MinimalCollection.up();
    }

    private static UnsupportedOperationException up() {
        throw new UnsupportedOperationException();
    }
}

