/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.AnEnum;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.UnhashableObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@GwtCompatible
public class SampleElements<E>
implements Iterable<E> {
    private final E e0;
    private final E e1;
    private final E e2;
    private final E e3;
    private final E e4;

    public SampleElements(E e0, E e1, E e2, E e3, E e4) {
        this.e0 = e0;
        this.e1 = e1;
        this.e2 = e2;
        this.e3 = e3;
        this.e4 = e4;
    }

    @Override
    public Iterator<E> iterator() {
        return this.asList().iterator();
    }

    public List<E> asList() {
        return Arrays.asList(this.e0(), this.e1(), this.e2(), this.e3(), this.e4());
    }

    public static <K, V> SampleElements<Map.Entry<K, V>> mapEntries(SampleElements<K> keys, SampleElements<V> values) {
        return new SampleElements<Map.Entry<K, V>>(Helpers.mapEntry(keys.e0(), values.e0()), Helpers.mapEntry(keys.e1(), values.e1()), Helpers.mapEntry(keys.e2(), values.e2()), Helpers.mapEntry(keys.e3(), values.e3()), Helpers.mapEntry(keys.e4(), values.e4()));
    }

    public E e0() {
        return this.e0;
    }

    public E e1() {
        return this.e1;
    }

    public E e2() {
        return this.e2;
    }

    public E e3() {
        return this.e3;
    }

    public E e4() {
        return this.e4;
    }

    private static class Collider {
        final int value;

        Collider(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof Collider && ((Collider)obj).value == this.value;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static class Colliders
    extends SampleElements<Object> {
        public Colliders() {
            super(new Collider(1), new Collider(2), new Collider(3), new Collider(4), new Collider(5));
        }
    }

    public static class Unhashables
    extends SampleElements<UnhashableObject> {
        public Unhashables() {
            super(new UnhashableObject(1), new UnhashableObject(2), new UnhashableObject(3), new UnhashableObject(4), new UnhashableObject(5));
        }
    }

    public static class Ints
    extends SampleElements<Integer> {
        public Ints() {
            super(1, 0, 2, 3, 4);
        }
    }

    public static class Enums
    extends SampleElements<AnEnum> {
        public Enums() {
            super(AnEnum.B, AnEnum.A, AnEnum.C, AnEnum.D, AnEnum.E);
        }
    }

    public static class Chars
    extends SampleElements<Character> {
        public Chars() {
            super(Character.valueOf('b'), Character.valueOf('a'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'));
        }
    }

    public static class Strings
    extends SampleElements<String> {
        public static final String BEFORE_FIRST = "\u0000";
        public static final String BEFORE_FIRST_2 = "\u0000\u0000";
        public static final String MIN_ELEMENT = "a";
        public static final String AFTER_LAST = "z";
        public static final String AFTER_LAST_2 = "zz";

        public Strings() {
            super("b", MIN_ELEMENT, "c", "d", "e");
        }
    }
}

