/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing;

import com.diffplug.common.collect.testing.MinimalCollection;
import com.diffplug.common.collect.testing.QueueTestSuiteBuilder;
import com.diffplug.common.collect.testing.TestStringQueueGenerator;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestsForQueuesInJavaUtil {
    public static Test suite() {
        return new TestsForQueuesInJavaUtil().allTests();
    }

    public Test allTests() {
        TestSuite suite = new TestSuite();
        suite.addTest(this.testsForLinkedList());
        suite.addTest(this.testsForArrayBlockingQueue());
        suite.addTest(this.testsForConcurrentLinkedQueue());
        suite.addTest(this.testsForLinkedBlockingQueue());
        suite.addTest(this.testsForPriorityBlockingQueue());
        suite.addTest(this.testsForPriorityQueue());
        return suite;
    }

    protected Collection<Method> suppressForLinkedList() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForArrayBlockingQueue() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForConcurrentLinkedQueue() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForLinkedBlockingQueue() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForPriorityBlockingQueue() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForPriorityQueue() {
        return Collections.emptySet();
    }

    public Test testsForLinkedList() {
        return ((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using(new TestStringQueueGenerator(){

            @Override
            public Queue<String> create(String[] elements) {
                return new LinkedList<String>(MinimalCollection.of(elements));
            }
        }).named("LinkedList")).withFeatures(CollectionFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY)).skipCollectionTests().suppressing(this.suppressForLinkedList())).createTestSuite();
    }

    public Test testsForArrayBlockingQueue() {
        return ((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using(new TestStringQueueGenerator(){

            @Override
            public Queue<String> create(String[] elements) {
                return new ArrayBlockingQueue<String>(100, false, MinimalCollection.of(elements));
            }
        }).named("ArrayBlockingQueue")).withFeatures(CollectionFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY)).suppressing(this.suppressForArrayBlockingQueue())).createTestSuite();
    }

    public Test testsForConcurrentLinkedQueue() {
        return ((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using(new TestStringQueueGenerator(){

            @Override
            public Queue<String> create(String[] elements) {
                return new ConcurrentLinkedQueue<String>(MinimalCollection.of(elements));
            }
        }).named("ConcurrentLinkedQueue")).withFeatures(CollectionFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY)).suppressing(this.suppressForConcurrentLinkedQueue())).createTestSuite();
    }

    public Test testsForLinkedBlockingQueue() {
        return ((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using(new TestStringQueueGenerator(){

            @Override
            public Queue<String> create(String[] elements) {
                return new LinkedBlockingQueue<String>(MinimalCollection.of(elements));
            }
        }).named("LinkedBlockingQueue")).withFeatures(CollectionFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY)).suppressing(this.suppressForLinkedBlockingQueue())).createTestSuite();
    }

    public Test testsForPriorityBlockingQueue() {
        return ((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using(new TestStringQueueGenerator(){

            @Override
            public Queue<String> create(String[] elements) {
                return new PriorityBlockingQueue<String>(MinimalCollection.of(elements));
            }
        }).named("PriorityBlockingQueue")).withFeatures(CollectionFeature.GENERAL_PURPOSE, CollectionSize.ANY)).suppressing(this.suppressForPriorityBlockingQueue())).createTestSuite();
    }

    public Test testsForPriorityQueue() {
        return ((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using(new TestStringQueueGenerator(){

            @Override
            public Queue<String> create(String[] elements) {
                return new PriorityQueue<String>(MinimalCollection.of(elements));
            }
        }).named("PriorityQueue")).withFeatures(CollectionFeature.GENERAL_PURPOSE, CollectionSize.ANY)).suppressing(this.suppressForPriorityQueue())).createTestSuite();
    }
}

