/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.features;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.features.Feature;
import com.diffplug.common.collect.testing.features.TesterAnnotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Set;

@GwtCompatible
public enum CollectionFeature implements Feature<Collection>
{
    ALLOWS_NULL_QUERIES(new Feature[0]),
    ALLOWS_NULL_VALUES(ALLOWS_NULL_QUERIES),
    RESTRICTS_ELEMENTS(new Feature[0]),
    KNOWN_ORDER(new Feature[0]),
    NON_STANDARD_TOSTRING(new Feature[0]),
    REJECTS_DUPLICATES_AT_CREATION(new Feature[0]),
    SUPPORTS_ADD(new Feature[0]),
    SUPPORTS_REMOVE(new Feature[0]),
    SUPPORTS_ITERATOR_REMOVE(new Feature[0]),
    FAILS_FAST_ON_CONCURRENT_MODIFICATION(new Feature[0]),
    GENERAL_PURPOSE(SUPPORTS_ADD, SUPPORTS_REMOVE, SUPPORTS_ITERATOR_REMOVE),
    REMOVE_OPERATIONS(SUPPORTS_REMOVE, SUPPORTS_ITERATOR_REMOVE),
    SERIALIZABLE(new Feature[0]),
    SERIALIZABLE_INCLUDING_VIEWS(SERIALIZABLE),
    SUBSET_VIEW(new Feature[0]),
    DESCENDING_VIEW(new Feature[0]),
    NONE(new Feature[0]);

    private final Set<Feature<? super Collection>> implied;

    private CollectionFeature(Feature<? super Collection> ... implied) {
        this.implied = Helpers.copyToSet(implied);
    }

    @Override
    public Set<Feature<? super Collection>> getImpliedFeatures() {
        return this.implied;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @TesterAnnotation
    public static @interface Require {
        public CollectionFeature[] value() default {};

        public CollectionFeature[] absent() default {};
    }
}

