/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.BiMap;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractBiMapTester;

@GwtCompatible
public class BiMapClearTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearClearsInverse() {
        BiMap inv = this.getMap().inverse();
        this.getMap().clear();
        BiMapClearTester.assertTrue((boolean)this.getMap().isEmpty());
        BiMapClearTester.assertTrue((boolean)inv.isEmpty());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeySetClearClearsInverse() {
        BiMap inv = this.getMap().inverse();
        this.getMap().keySet().clear();
        BiMapClearTester.assertTrue((boolean)this.getMap().isEmpty());
        BiMapClearTester.assertTrue((boolean)inv.isEmpty());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testValuesClearClearsInverse() {
        BiMap inv = this.getMap().inverse();
        this.getMap().values().clear();
        BiMapClearTester.assertTrue((boolean)this.getMap().isEmpty());
        BiMapClearTester.assertTrue((boolean)inv.isEmpty());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearInverseClears() {
        BiMap inv = this.getMap().inverse();
        inv.clear();
        BiMapClearTester.assertTrue((boolean)this.getMap().isEmpty());
        BiMapClearTester.assertTrue((boolean)inv.isEmpty());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearInverseKeySetClears() {
        BiMap inv = this.getMap().inverse();
        inv.keySet().clear();
        BiMapClearTester.assertTrue((boolean)this.getMap().isEmpty());
        BiMapClearTester.assertTrue((boolean)inv.isEmpty());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClearInverseValuesClears() {
        BiMap inv = this.getMap().inverse();
        inv.values().clear();
        BiMapClearTester.assertTrue((boolean)this.getMap().isEmpty());
        BiMapClearTester.assertTrue((boolean)inv.isEmpty());
    }
}

