/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Multimap;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;

@GwtCompatible
public class MultimapAsMapGetTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()), Helpers.mapEntry(this.k0(), this.v2()));
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        MultimapAsMapGetTester.assertTrue((boolean)result.remove(this.v0()));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsEntry(this.k0(), this.v0()));
        MultimapAsMapGetTester.assertEquals((int)2, (int)this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveLastElementToMultimap() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        MultimapAsMapGetTester.assertTrue((boolean)result.remove(this.v0()));
        this.assertGet(this.k0(), new Object[0]);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesClearToMultimap() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        result.clear();
        this.assertGet(this.k0(), new Object[0]);
        Helpers.assertEmpty(result);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testAddNullValue() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        MultimapAsMapGetTester.assertTrue((boolean)result.add(null));
        MultimapAsMapGetTester.assertTrue((boolean)this.multimap().containsEntry(this.k0(), null));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testRemoveNullValue() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        MultimapAsMapGetTester.assertFalse((boolean)result.remove(null));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testAddNullValueUnsupported() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        try {
            result.add(null);
            MultimapAsMapGetTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPropagatesAddToMultimap() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        result.add(this.v3());
        Helpers.assertContentsAnyOrder(this.multimap().get(this.k0()), this.v0(), this.v3());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.SUPPORTS_PUT})
    public void testPropagatesRemoveThenAddToMultimap() {
        int oldSize = this.getNumElements();
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        MultimapAsMapGetTester.assertTrue((boolean)result.remove(this.v0()));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsKey(this.k0()));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsEntry(this.k0(), this.v0()));
        Helpers.assertEmpty(result);
        MultimapAsMapGetTester.assertTrue((boolean)result.add(this.v1()));
        MultimapAsMapGetTester.assertTrue((boolean)result.add(this.v2()));
        Helpers.assertContentsAnyOrder(result, this.v1(), this.v2());
        Helpers.assertContentsAnyOrder(this.multimap().get(this.k0()), this.v1(), this.v2());
        MultimapAsMapGetTester.assertTrue((boolean)this.multimap().containsKey(this.k0()));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsEntry(this.k0(), this.v0()));
        MultimapAsMapGetTester.assertTrue((boolean)this.multimap().containsEntry(this.k0(), this.v2()));
        MultimapAsMapGetTester.assertEquals((int)(oldSize + 1), (int)this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testReflectsMultimapRemove() {
        Collection result = (Collection)this.multimap().asMap().get(this.k0());
        this.multimap().removeAll(this.k0());
        Helpers.assertEmpty(result);
    }
}

