/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Multimap;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractMultimapTester;

@GwtCompatible
public class MultimapContainsEntryTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsEntryYes() {
        MultimapContainsEntryTester.assertTrue((boolean)this.multimap().containsEntry(this.k0(), this.v0()));
    }

    public void testContainsEntryNo() {
        MultimapContainsEntryTester.assertFalse((boolean)this.multimap().containsEntry(this.k3(), this.v3()));
    }

    public void testContainsEntryAgreesWithGet() {
        for (Object k : this.sampleKeys()) {
            for (Object v : this.sampleValues()) {
                MultimapContainsEntryTester.assertEquals((boolean)this.multimap().get(k).contains(v), (boolean)this.multimap().containsEntry(k, v));
            }
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryNullYes() {
        this.initMultimapWithNullKeyAndValue();
        MultimapContainsEntryTester.assertTrue((boolean)this.multimap().containsEntry(null, null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES, MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryNullNo() {
        MultimapContainsEntryTester.assertFalse((boolean)this.multimap().containsEntry(null, null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsEntryNullDisallowedBecauseKeyQueriesDisallowed() {
        try {
            this.multimap().containsEntry(null, this.v3());
            MultimapContainsEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryNullDisallowedBecauseValueQueriesDisallowed() {
        try {
            this.multimap().containsEntry(this.k3(), null);
            MultimapContainsEntryTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

