/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Multimap;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractMultimapTester;

@GwtCompatible
public class MultimapContainsValueTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsValueYes() {
        MultimapContainsValueTester.assertTrue((boolean)this.multimap().containsValue(this.v0()));
    }

    public void testContainsValueNo() {
        MultimapContainsValueTester.assertFalse((boolean)this.multimap().containsValue(this.v3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsNullValueYes() {
        this.initMultimapWithNullValue();
        MultimapContainsValueTester.assertTrue((boolean)this.multimap().containsValue(null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsNullValueNo() {
        MultimapContainsValueTester.assertFalse((boolean)this.multimap().containsValue(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsNullValueFails() {
        try {
            this.multimap().containsValue(null);
            MultimapContainsValueTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

