/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Multimap;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.OneSizeTestContainerGenerator;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractMultimapTester;
import com.diffplug.common.testing.EqualsTester;
import java.util.ArrayList;

@GwtCompatible
public class MultimapEqualsTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testEqualsTrue() {
        new EqualsTester().addEqualityGroup(this.multimap(), ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.getSampleElements().toArray())).testEquals();
    }

    public void testEqualsFalse() {
        ArrayList targetEntries = new ArrayList(this.getSampleElements());
        targetEntries.add(Helpers.mapEntry(this.k0(), this.v3()));
        new EqualsTester().addEqualityGroup(this.multimap()).addEqualityGroup(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(targetEntries.toArray())).testEquals();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testEqualsMultimapWithNullKey() {
        Object original = this.multimap();
        this.initMultimapWithNullKey();
        Object withNull = this.multimap();
        new EqualsTester().addEqualityGroup(original).addEqualityGroup(withNull, ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullKey())).testEquals();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testEqualsMultimapWithNullValue() {
        Object original = this.multimap();
        this.initMultimapWithNullValue();
        Object withNull = this.multimap();
        new EqualsTester().addEqualityGroup(original).addEqualityGroup(withNull, ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullValue())).testEquals();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testNotEqualsEmpty() {
        new EqualsTester().addEqualityGroup(this.multimap()).addEqualityGroup(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(new Object[0])).testEquals();
    }

    public void testHashCodeMatchesAsMap() {
        MultimapEqualsTester.assertEquals((int)this.multimap().asMap().hashCode(), (int)this.multimap().hashCode());
    }
}

