/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Multimap;
import com.diffplug.common.collect.Multiset;
import com.diffplug.common.collect.Multisets;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractMultimapTester;
import java.util.Iterator;

@GwtCompatible
public class MultimapKeysTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testKeys() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k1(), this.v0()));
        Multiset keys = this.multimap().keys();
        MultimapKeysTester.assertEquals((int)2, (int)keys.count(this.k0()));
        MultimapKeysTester.assertEquals((int)1, (int)keys.count(this.k1()));
        MultimapKeysTester.assertEquals((int)3, (int)keys.size());
        Helpers.assertContainsAllOf(keys, new Object[]{this.k0(), this.k1()});
        Helpers.assertContainsAllOf(keys.entrySet(), Multisets.immutableEntry(this.k0(), (int)2), Multisets.immutableEntry(this.k1(), (int)1));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testKeysCountAbsentNullKey() {
        MultimapKeysTester.assertEquals((int)0, (int)this.multimap().keys().count(null));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testKeysWithNullKey() {
        this.resetContainer(Helpers.mapEntry(null, this.v0()), Helpers.mapEntry(null, this.v1()), Helpers.mapEntry(this.k1(), this.v0()));
        Multiset keys = this.multimap().keys();
        MultimapKeysTester.assertEquals((int)2, (int)keys.count(null));
        MultimapKeysTester.assertEquals((int)1, (int)keys.count(this.k1()));
        MultimapKeysTester.assertEquals((int)3, (int)keys.size());
        Helpers.assertContainsAllOf(keys, new Object[]{null, this.k1()});
        Helpers.assertContainsAllOf(keys.entrySet(), Multisets.immutableEntry(null, (int)2), Multisets.immutableEntry(this.k1(), (int)1));
    }

    public void testKeysElementSet() {
        MultimapKeysTester.assertEquals((Object)this.multimap().keySet(), (Object)this.multimap().keys().elementSet());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeysRemove() {
        int original = this.multimap().keys().remove(this.k0(), 1);
        MultimapKeysTester.assertEquals((int)Math.max(original - 1, 0), (int)this.multimap().get(this.k0()).size());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testKeysEntrySetIteratorRemove() {
        Multiset keys = this.multimap().keys();
        Iterator itr = keys.entrySet().iterator();
        MultimapKeysTester.assertEquals((Object)Multisets.immutableEntry(this.k0(), (int)1), itr.next());
        itr.remove();
        MultimapKeysTester.assertTrue((boolean)this.multimap().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeysEntrySetRemove() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k1(), this.v0()));
        MultimapKeysTester.assertTrue((boolean)this.multimap().keys().entrySet().remove(Multisets.immutableEntry(this.k0(), (int)2)));
        MultimapKeysTester.assertEquals((int)1, (int)this.multimap().size());
        MultimapKeysTester.assertTrue((boolean)this.multimap().containsEntry(this.k1(), this.v0()));
    }
}

