/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Multimap;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.OneSizeTestContainerGenerator;
import com.diffplug.common.collect.testing.features.MapFeature;
import com.diffplug.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;

@GwtCompatible
public class MultimapPutAllMultimapTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutUnsupported() {
        try {
            this.multimap().putAll((Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.k3(), this.v3())));
            MultimapPutAllMultimapTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllIntoEmpty() {
        Multimap target = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(new Object[0]);
        MultimapPutAllMultimapTester.assertEquals((!this.multimap().isEmpty() ? 1 : 0) != 0, (boolean)target.putAll(this.multimap()));
        MultimapPutAllMultimapTester.assertEquals(this.multimap(), (Object)target);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll() {
        Multimap source = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.k0(), this.v3()), Helpers.mapEntry(this.k3(), this.v3()));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().putAll(source));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().containsEntry(this.k0(), this.v3()));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().containsEntry(this.k3(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllWithNullValue() {
        Multimap source = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.k0(), null));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().putAll(source));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().containsEntry(this.k0(), null));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllWithNullKey() {
        Multimap source = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(null, this.v0()));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().putAll(source));
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().containsEntry(null, this.v0()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAllRejectsNullValue() {
        Multimap source = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.k0(), null));
        try {
            this.multimap().putAll(source);
            MultimapPutAllMultimapTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAllRejectsNullKey() {
        Multimap source = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(null, this.v0()));
        try {
            this.multimap().putAll(source);
            MultimapPutAllMultimapTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAllPropagatesToGet() {
        Multimap source = (Multimap)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(Helpers.mapEntry(this.k0(), this.v3()), Helpers.mapEntry(this.k3(), this.v3()));
        Collection getCollection = this.multimap().get(this.k0());
        int getCollectionSize = getCollection.size();
        MultimapPutAllMultimapTester.assertTrue((boolean)this.multimap().putAll(source));
        MultimapPutAllMultimapTester.assertEquals((int)(getCollectionSize + 1), (int)getCollection.size());
        Helpers.assertContains(getCollection, this.v3());
    }
}

