/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.google;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.Iterables;
import com.diffplug.common.collect.Multiset;
import com.diffplug.common.collect.Multisets;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.google.AbstractMultisetTester;
import com.diffplug.common.collect.testing.google.MultisetFeature;
import java.util.Collections;
import java.util.Iterator;

@GwtCompatible
public class MultisetEntrySetTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_clear() {
        this.getMultiset().entrySet().clear();
        MultisetEntrySetTester.assertTrue((String)"multiset not empty after entrySet().clear()", (boolean)this.getMultiset().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testEntrySet_iteratorRemovePropagates() {
        Iterator iterator = this.getMultiset().entrySet().iterator();
        MultisetEntrySetTester.assertTrue((String)"non-empty multiset.entrySet() iterator.hasNext() returned false", (boolean)iterator.hasNext());
        MultisetEntrySetTester.assertEquals((String)"multiset.entrySet() iterator.next() returned incorrect entry", (Object)Multisets.immutableEntry(this.e0(), (int)1), iterator.next());
        MultisetEntrySetTester.assertFalse((String)"size 1 multiset.entrySet() iterator.hasNext() returned true after next()", (boolean)iterator.hasNext());
        iterator.remove();
        MultisetEntrySetTester.assertTrue((String)"multiset isn't empty after multiset.entrySet() iterator.remove()", (boolean)this.getMultiset().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removePresent() {
        MultisetEntrySetTester.assertTrue((String)"multiset.entrySet.remove(presentEntry) returned false", (boolean)this.getMultiset().entrySet().remove(Multisets.immutableEntry(this.e0(), (int)1)));
        MultisetEntrySetTester.assertFalse((String)"multiset contains element after removing its entry", (boolean)this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAbsent() {
        MultisetEntrySetTester.assertFalse((String)"multiset.entrySet.remove(missingEntry) returned true", (boolean)this.getMultiset().entrySet().remove(Multisets.immutableEntry(this.e0(), (int)2)));
        MultisetEntrySetTester.assertTrue((String)"multiset didn't contain element after removing a missing entry", (boolean)this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAllPresent() {
        MultisetEntrySetTester.assertTrue((String)"multiset.entrySet.removeAll(presentEntry) returned false", (boolean)this.getMultiset().entrySet().removeAll(Collections.singleton(Multisets.immutableEntry(this.e0(), (int)1))));
        MultisetEntrySetTester.assertFalse((String)"multiset contains element after removing its entry", (boolean)this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_removeAllAbsent() {
        MultisetEntrySetTester.assertFalse((String)"multiset.entrySet.remove(missingEntry) returned true", (boolean)this.getMultiset().entrySet().removeAll(Collections.singleton(Multisets.immutableEntry(this.e0(), (int)2))));
        MultisetEntrySetTester.assertTrue((String)"multiset didn't contain element after removing a missing entry", (boolean)this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAllPresent() {
        MultisetEntrySetTester.assertFalse((String)"multiset.entrySet.retainAll(presentEntry) returned false", (boolean)this.getMultiset().entrySet().retainAll(Collections.singleton(Multisets.immutableEntry(this.e0(), (int)1))));
        MultisetEntrySetTester.assertTrue((String)"multiset doesn't contains element after retaining its entry", (boolean)this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testEntrySet_retainAllAbsent() {
        MultisetEntrySetTester.assertTrue((String)"multiset.entrySet.retainAll(missingEntry) returned true", (boolean)this.getMultiset().entrySet().retainAll(Collections.singleton(Multisets.immutableEntry(this.e0(), (int)2))));
        MultisetEntrySetTester.assertFalse((String)"multiset contains element after retaining a different entry", (boolean)this.getMultiset().contains(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryViewReflectsRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        MultisetEntrySetTester.assertTrue((boolean)this.getMultiset().remove(this.e0()));
        MultisetEntrySetTester.assertEquals((int)2, (int)entry.getCount());
        MultisetEntrySetTester.assertTrue((boolean)this.getMultiset().elementSet().remove(this.e0()));
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsIteratorRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        Iterator itr = this.getMultiset().iterator();
        itr.next();
        itr.remove();
        MultisetEntrySetTester.assertEquals((int)2, (int)entry.getCount());
        itr.next();
        itr.remove();
        itr.next();
        itr.remove();
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsClear() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        this.getMultiset().clear();
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsEntrySetClear() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        this.getMultiset().entrySet().clear();
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsEntrySetIteratorRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Iterator entryItr = this.getMultiset().entrySet().iterator();
        Multiset.Entry entry = (Multiset.Entry)entryItr.next();
        entryItr.remove();
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsElementSetClear() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        this.getMultiset().elementSet().clear();
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsElementSetIteratorRemove() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        Iterator elementItr = this.getMultiset().elementSet().iterator();
        elementItr.next();
        elementItr.remove();
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.SUPPORTS_ADD})
    @MultisetFeature.Require(value={MultisetFeature.ENTRIES_ARE_VIEWS})
    public void testEntryReflectsRemoveThenAdd() {
        this.initThreeCopies();
        MultisetEntrySetTester.assertEquals((int)3, (int)this.getMultiset().count(this.e0()));
        Multiset.Entry entry = (Multiset.Entry)Iterables.getOnlyElement((Iterable)this.getMultiset().entrySet());
        MultisetEntrySetTester.assertEquals((int)3, (int)entry.getCount());
        MultisetEntrySetTester.assertTrue((boolean)this.getMultiset().remove(this.e0()));
        MultisetEntrySetTester.assertEquals((int)2, (int)entry.getCount());
        MultisetEntrySetTester.assertTrue((boolean)this.getMultiset().elementSet().remove(this.e0()));
        MultisetEntrySetTester.assertEquals((int)0, (int)entry.getCount());
        this.getMultiset().add(this.e0(), 2);
        MultisetEntrySetTester.assertEquals((int)2, (int)entry.getCount());
    }

    public void testToString() {
        MultisetEntrySetTester.assertEquals((String)this.getMultiset().entrySet().toString(), (String)this.getMultiset().toString());
    }
}

