/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.testers;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.annotations.GwtIncompatible;
import com.diffplug.common.collect.testing.AbstractCollectionTester;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.OneSizeTestContainerGenerator;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;
import java.util.Collection;

@GwtCompatible(emulated=true)
public class CollectionCreationTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNull_supported() {
        Object[] array = this.createArrayWithNullElement();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        this.expectContents(array);
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNull_unsupported() {
        Object[] array = this.createArrayWithNullElement();
        try {
            ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
            CollectionCreationTester.fail((String)"Creating a collection containing null should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="reflection")
    public static Method getCreateWithNullUnsupportedMethod() {
        return Helpers.getMethod(CollectionCreationTester.class, "testCreateWithNull_unsupported");
    }
}

