/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.testers;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.MinimalCollection;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.testers.AbstractListTester;

@GwtCompatible
public class ListAddAllTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_supportedAllPresent() {
        ListAddAllTester.assertTrue((String)"addAll(allPresent) should return true", (boolean)this.getList().addAll(MinimalCollection.of(this.e0())));
        this.expectAdded(this.e0());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAddAll_unsupportedAllPresent() {
        try {
            this.getList().addAll(MinimalCollection.of(this.e0()));
            ListAddAllTester.fail((String)"addAll(allPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_withDuplicates() {
        MinimalCollection<Object> elementsToAdd = MinimalCollection.of(this.e0(), this.e1(), this.e0(), this.e1());
        ListAddAllTester.assertTrue((String)"addAll(hasDuplicates) should return true", (boolean)this.getList().addAll(elementsToAdd));
        this.expectAdded(this.e0(), this.e1(), this.e0(), this.e1());
    }
}

