/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.testers;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.MinimalCollection;
import com.diffplug.common.collect.testing.OneSizeTestContainerGenerator;
import com.diffplug.common.collect.testing.features.CollectionFeature;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.testers.AbstractListTester;
import java.util.Arrays;
import java.util.Collection;

@GwtCompatible
public class ListRetainAllTester<E>
extends AbstractListTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO, CollectionSize.ONE})
    public void testRetainAll_duplicatesKept() {
        Object[] array = this.createSamplesArray();
        array[1] = this.e0();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        ListRetainAllTester.assertFalse((String)"containsDuplicates.retainAll(superset) should return false", (boolean)this.collection.retainAll(MinimalCollection.of(this.createSamplesArray())));
        this.expectContents(array);
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRetainAll_duplicatesRemoved() {
        Object[] array = this.createSamplesArray();
        array[1] = this.e0();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        ListRetainAllTester.assertTrue((String)"containsDuplicates.retainAll(subset) should return true", (boolean)this.collection.retainAll(MinimalCollection.of(this.e2())));
        this.expectContents(this.e2());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRetainAll_countIgnored() {
        this.resetContainer((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.e0(), this.e2(), this.e1(), this.e0()));
        ListRetainAllTester.assertTrue((boolean)this.getList().retainAll(Arrays.asList(this.e0(), this.e1())));
        Helpers.assertContentsInOrder(this.getList(), this.e0(), this.e1(), this.e0());
    }
}

