/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.testers;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.AbstractMapTester;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

@GwtCompatible
public class MapClearTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClear() {
        this.getMap().clear();
        MapClearTester.assertTrue((String)"After clear(), a map should be empty.", (boolean)this.getMap().isEmpty());
        MapClearTester.assertEquals((int)0, (int)this.getMap().size());
        MapClearTester.assertFalse((boolean)this.getMap().entrySet().iterator().hasNext());
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithEntrySetIteration() {
        try {
            Iterator iterator = this.getMap().entrySet().iterator();
            this.getMap().clear();
            iterator.next();
            MapClearTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithKeySetIteration() {
        try {
            Iterator iterator = this.getMap().keySet().iterator();
            this.getMap().clear();
            iterator.next();
            MapClearTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithValuesIteration() {
        try {
            Iterator iterator = this.getMap().values().iterator();
            this.getMap().clear();
            iterator.next();
            MapClearTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClear_unsupported() {
        try {
            this.getMap().clear();
            MapClearTester.fail((String)"clear() should throw UnsupportedOperation if a map does not support it and is not empty.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testClear_unsupportedByEmptyCollection() {
        try {
            this.getMap().clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

