/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.testers;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.collect.testing.AbstractMapTester;
import com.diffplug.common.collect.testing.WrongType;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;

@GwtCompatible
public class MapGetTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGet_yes() {
        MapGetTester.assertEquals((String)"get(present) should return the associated value", this.v0(), this.get(this.k0()));
    }

    public void testGet_no() {
        MapGetTester.assertNull((String)"get(notPresent) should return null", this.get(this.k3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testGet_nullNotContainedButAllowed() {
        MapGetTester.assertNull((String)"get(null) should return null", this.get(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testGet_nullNotContainedAndUnsupported() {
        try {
            MapGetTester.assertNull((String)"get(null) should return null or throw", this.get(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGet_nonNullWhenNullContained() {
        this.initMapWithNullKey();
        MapGetTester.assertNull((String)"get(notPresent) should return null", this.get(this.k3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGet_nullContained() {
        this.initMapWithNullKey();
        MapGetTester.assertEquals((String)"get(null) should return the associated value", this.getValueForNullKey(), this.get(null));
    }

    public void testGet_wrongType() {
        try {
            MapGetTester.assertNull((String)"get(wrongType) should return null or throw", this.getMap().get((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

