/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.collect.testing.testers;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.annotations.GwtIncompatible;
import com.diffplug.common.collect.testing.AbstractMapTester;
import com.diffplug.common.collect.testing.Helpers;
import com.diffplug.common.collect.testing.MinimalCollection;
import com.diffplug.common.collect.testing.features.CollectionSize;
import com.diffplug.common.collect.testing.features.MapFeature;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@GwtCompatible(emulated=true)
public class MapPutAllTester<K, V>
extends AbstractMapTester<K, V> {
    private List<Map.Entry<K, V>> containsNullKey;
    private List<Map.Entry<K, V>> containsNullValue;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.containsNullKey = Collections.singletonList(this.entry(null, this.v3()));
        this.containsNullValue = Collections.singletonList(this.entry(this.k3(), null));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll_supportedNothing() {
        this.getMap().putAll(this.emptyMap());
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutAll_unsupportedNothing() {
        try {
            this.getMap().putAll(this.emptyMap());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll_supportedNonePresent() {
        this.putAll(this.createDisjointCollection());
        this.expectAdded((Map.Entry)this.e3(), (Map.Entry)this.e4());
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutAll_unsupportedNonePresent() {
        try {
            this.putAll(this.createDisjointCollection());
            MapPutAllTester.fail((String)"putAll(nonePresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing((Map.Entry)this.e3(), (Map.Entry)this.e4());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAll_supportedSomePresent() {
        this.putAll(MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e0()));
        this.expectAdded((Map.Entry)this.e3());
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAllSomePresentConcurrentWithEntrySetIteration() {
        try {
            Iterator iterator = this.getMap().entrySet().iterator();
            this.putAll(MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e0()));
            iterator.next();
            MapPutAllTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAll_unsupportedSomePresent() {
        try {
            this.putAll(MinimalCollection.of((Map.Entry)this.e3(), (Map.Entry)this.e0()));
            MapPutAllTester.fail((String)"putAll(somePresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutAll_unsupportedAllPresent() {
        try {
            this.putAll(MinimalCollection.of((Map.Entry)this.e0()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAll_nullKeySupported() {
        this.putAll(this.containsNullKey);
        this.expectAdded(this.containsNullKey.get(0));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEYS})
    public void testPutAll_nullKeyUnsupported() {
        try {
            this.putAll(this.containsNullKey);
            MapPutAllTester.fail((String)"putAll(containsNullKey) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullKeyMissingWhenNullKeysUnsupported("Should not contain null key after unsupported putAll(containsNullKey)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAll_nullValueSupported() {
        this.putAll(this.containsNullValue);
        this.expectAdded(this.containsNullValue.get(0));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutAll_nullValueUnsupported() {
        try {
            this.putAll(this.containsNullValue);
            MapPutAllTester.fail((String)"putAll(containsNullValue) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullValueMissingWhenNullValuesUnsupported("Should not contain null value after unsupported putAll(containsNullValue)");
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutAll_nullCollectionReference() {
        try {
            this.getMap().putAll(null);
            MapPutAllTester.fail((String)"putAll(null) should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    private void putAll(Iterable<Map.Entry<K, V>> entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        this.getMap().putAll(map);
    }

    @GwtIncompatible(value="reflection")
    public static Method getPutAllNullKeyUnsupportedMethod() {
        return Helpers.getMethod(MapPutAllTester.class, "testPutAll_nullKeyUnsupported");
    }
}

