/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.testing;

import com.diffplug.common.annotations.Beta;
import com.diffplug.common.annotations.VisibleForTesting;
import com.diffplug.common.base.Predicates;
import com.diffplug.common.collect.HashMultimap;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.Iterables;
import com.diffplug.common.collect.Lists;
import com.diffplug.common.collect.Maps;
import com.diffplug.common.collect.Sets;
import com.diffplug.common.reflect.ClassPath;
import com.diffplug.common.testing.ClassSanityTester;
import com.diffplug.common.testing.NullPointerTester;
import com.diffplug.common.testing.SerializableTester;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.junit.Test;

@Beta
public abstract class AbstractPackageSanityTests
extends TestCase {
    public static final Predicate<Class<?>> UNDERSCORE_IN_NAME = new Predicate<Class<?>>(){

        @Override
        public boolean test(Class<?> c) {
            return c.getSimpleName().contains("_");
        }
    };
    private static final ImmutableList<String> NULL_TEST_METHOD_NAMES = ImmutableList.of((Object)"testNulls", (Object)"testNull", (Object)"testNullPointers", (Object)"testNullPointer", (Object)"testNullPointerExceptions", (Object)"testNullPointerException");
    private static final ImmutableList<String> SERIALIZABLE_TEST_METHOD_NAMES = ImmutableList.of((Object)"testSerializable", (Object)"testSerialization", (Object)"testEqualsAndSerializable", (Object)"testEqualsAndSerialization");
    private static final ImmutableList<String> EQUALS_TEST_METHOD_NAMES = ImmutableList.of((Object)"testEquals", (Object)"testEqualsAndHashCode", (Object)"testEqualsAndSerializable", (Object)"testEqualsAndSerialization", (Object)"testEquality");
    private static final Chopper TEST_SUFFIX = Chopper.suffix("Test").or(Chopper.suffix("Tests")).or(Chopper.suffix("TestCase")).or(Chopper.suffix("TestSuite"));
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final ClassSanityTester tester = new ClassSanityTester();
    private NullPointerTester.Visibility visibility = NullPointerTester.Visibility.PACKAGE;
    private Predicate<Class<?>> classFilter = new Predicate<Class<?>>(){

        @Override
        public boolean test(Class<?> cls) {
            return AbstractPackageSanityTests.this.visibility.isVisible(cls.getModifiers());
        }
    };

    protected final void publicApiOnly() {
        this.visibility = NullPointerTester.Visibility.PUBLIC;
    }

    @Test
    public void testSerializable() throws Exception {
        for (Class<?> classToTest : this.findClassesToTest((Iterable<? extends Class<?>>)this.loadClassesInPackage(), (Iterable<String>)SERIALIZABLE_TEST_METHOD_NAMES)) {
            if (!Serializable.class.isAssignableFrom(classToTest)) continue;
            try {
                Object instance = this.tester.instantiate(classToTest);
                if (instance == null) continue;
                if (AbstractPackageSanityTests.isEqualsDefined(classToTest)) {
                    SerializableTester.reserializeAndAssert(instance);
                    continue;
                }
                SerializableTester.reserialize(instance);
            }
            catch (Throwable e) {
                throw AbstractPackageSanityTests.sanityError(classToTest, SERIALIZABLE_TEST_METHOD_NAMES, "serializable test", e);
            }
        }
    }

    @Test
    public void testNulls() throws Exception {
        for (Class<?> classToTest : this.findClassesToTest((Iterable<? extends Class<?>>)this.loadClassesInPackage(), (Iterable<String>)NULL_TEST_METHOD_NAMES)) {
            try {
                this.tester.doTestNulls(classToTest, this.visibility);
            }
            catch (Throwable e) {
                throw AbstractPackageSanityTests.sanityError(classToTest, NULL_TEST_METHOD_NAMES, "nulls test", e);
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        for (Class<?> classToTest : this.findClassesToTest((Iterable<? extends Class<?>>)this.loadClassesInPackage(), (Iterable<String>)EQUALS_TEST_METHOD_NAMES)) {
            if (classToTest.isEnum() || !AbstractPackageSanityTests.isEqualsDefined(classToTest)) continue;
            try {
                this.tester.doTestEquals(classToTest);
            }
            catch (Throwable e) {
                throw AbstractPackageSanityTests.sanityError(classToTest, EQUALS_TEST_METHOD_NAMES, "equals test", e);
            }
        }
    }

    protected final <T> void setDefault(Class<T> type, T value) {
        this.tester.setDefault(type, value);
    }

    protected final <T> void setDistinctValues(Class<T> type, T value1, T value2) {
        this.tester.setDistinctValues(type, value1, value2);
    }

    protected final void ignoreClasses(Predicate<? super Class<?>> condition) {
        this.classFilter = Predicates.and(this.classFilter, (Predicate)Predicates.not(condition));
    }

    private static AssertionFailedError sanityError(Class<?> cls, List<String> explicitTestNames, String description, Throwable e) {
        String message = String.format(Locale.ROOT, "Error in automated %s of %s\nIf the class is better tested explicitly, you can add %s() to %sTest", description, cls, explicitTestNames.get(0), cls.getName());
        AssertionFailedError error = new AssertionFailedError(message);
        error.initCause(e);
        return error;
    }

    @VisibleForTesting
    List<Class<?>> findClassesToTest(Iterable<? extends Class<?>> classes, Iterable<String> explicitTestNames) {
        TreeMap classMap = Maps.newTreeMap();
        for (Class<?> cls : classes) {
            classMap.put(cls.getName(), cls);
        }
        HashMultimap testClasses = HashMultimap.create();
        LinkedHashSet candidateClasses = Sets.newLinkedHashSet();
        for (Class<?> cls : classes) {
            Optional<String> testedClassName = TEST_SUFFIX.chop(cls.getName());
            if (testedClassName.isPresent()) {
                Class testedClass = (Class)classMap.get(testedClassName.get());
                if (testedClass == null) continue;
                testClasses.put((Object)testedClass, cls);
                continue;
            }
            candidateClasses.add(cls);
        }
        ArrayList result = Lists.newArrayList();
        block2: for (Class candidate : Iterables.filter((Iterable)candidateClasses, this.classFilter)) {
            for (Class testClass : testClasses.get((Object)candidate)) {
                if (!AbstractPackageSanityTests.hasTest(testClass, explicitTestNames)) continue;
                continue block2;
            }
            result.add(candidate);
        }
        return result;
    }

    private List<Class<?>> loadClassesInPackage() throws IOException {
        ArrayList classes = Lists.newArrayList();
        String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
        for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getTopLevelClasses(packageName)) {
            Class cls;
            try {
                cls = classInfo.load();
            }
            catch (NoClassDefFoundError e) {
                this.logger.log(Level.SEVERE, "Cannot load class " + classInfo + ", skipping...", e);
                continue;
            }
            if (cls.isInterface()) continue;
            classes.add(cls);
        }
        return classes;
    }

    private static boolean hasTest(Class<?> testClass, Iterable<String> testNames) {
        for (String testName : testNames) {
            try {
                testClass.getMethod(testName, new Class[0]);
                return true;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return false;
    }

    private static boolean isEqualsDefined(Class<?> cls) {
        try {
            return !cls.getDeclaredMethod("equals", Object.class).isSynthetic();
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static abstract class Chopper {
        Chopper() {
        }

        final Chopper or(final Chopper you) {
            final Chopper i = this;
            return new Chopper(){

                @Override
                Optional<String> chop(String str) {
                    Optional<String> first = i.chop(str);
                    Optional<String> second = you.chop(str);
                    if (first.isPresent()) {
                        return first;
                    }
                    return second;
                }
            };
        }

        abstract Optional<String> chop(String var1);

        static Chopper suffix(final String suffix) {
            return new Chopper(){

                @Override
                Optional<String> chop(String str) {
                    if (str.endsWith(suffix)) {
                        return Optional.of(str.substring(0, str.length() - suffix.length()));
                    }
                    return Optional.empty();
                }
            };
        }
    }
}

