/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.testing;

import com.diffplug.common.annotations.Beta;
import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.base.Equivalence;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.Lists;
import com.diffplug.common.testing.RelationshipTester;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;

@Beta
@GwtCompatible
public final class EquivalenceTester<T> {
    private static final int REPETITIONS = 3;
    private final Equivalence<? super T> equivalence;
    private final RelationshipTester<T> delegate;
    private final List<T> items = Lists.newArrayList();

    private EquivalenceTester(Equivalence<? super T> equivalence) {
        this.equivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        this.delegate = new RelationshipTester<T>(equivalence, "equivalent", "hash", new RelationshipTester.ItemReporter());
    }

    public static <T> EquivalenceTester<T> of(Equivalence<? super T> equivalence) {
        return new EquivalenceTester<T>(equivalence);
    }

    public EquivalenceTester<T> addEquivalenceGroup(T first, T ... rest) {
        this.addEquivalenceGroup(Lists.asList(first, (Object[])rest));
        return this;
    }

    public EquivalenceTester<T> addEquivalenceGroup(Iterable<T> group) {
        this.delegate.addRelatedGroup(group);
        this.items.addAll((Collection<T>)ImmutableList.copyOf(group));
        return this;
    }

    public EquivalenceTester<T> test() {
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            this.delegate.test();
        }
        return this;
    }

    private void testItems() {
        for (T item : this.items) {
            Assert.assertTrue((String)(item + " must be inequivalent to null"), (!this.equivalence.equivalent(item, null) ? 1 : 0) != 0);
            Assert.assertTrue((String)("null must be inequivalent to " + item), (!this.equivalence.equivalent(null, item) ? 1 : 0) != 0);
            Assert.assertTrue((String)(item + " must be equivalent to itself"), (boolean)this.equivalence.equivalent(item, item));
            Assert.assertEquals((String)("the hash of " + item + " must be consistent"), (int)this.equivalence.hash(item), (int)this.equivalence.hash(item));
        }
    }
}

