/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.testing;

import com.diffplug.common.annotations.Beta;
import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Beta
@GwtCompatible
public class FakeTicker
extends Ticker {
    private final AtomicLong nanos = new AtomicLong();
    private volatile long autoIncrementStepNanos;

    public FakeTicker advance(long time, TimeUnit timeUnit) {
        return this.advance(timeUnit.toNanos(time));
    }

    public FakeTicker advance(long nanoseconds) {
        this.nanos.addAndGet(nanoseconds);
        return this;
    }

    public FakeTicker setAutoIncrementStep(long autoIncrementStep, TimeUnit timeUnit) {
        Preconditions.checkArgument((autoIncrementStep >= 0L ? 1 : 0) != 0, (Object)"May not auto-increment by a negative amount");
        this.autoIncrementStepNanos = timeUnit.toNanos(autoIncrementStep);
        return this;
    }

    public long read() {
        return this.nanos.getAndAdd(this.autoIncrementStepNanos);
    }
}

