/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.testing;

import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@GwtCompatible(emulated=true)
final class Platform {
    static <T> T reserialize(T object) {
        Preconditions.checkNotNull(object);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(object);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Platform() {
    }
}

