/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.testing;

import com.diffplug.common.annotations.Beta;
import com.diffplug.common.annotations.GwtCompatible;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.testing.ClusterException;
import com.diffplug.common.testing.TearDown;
import com.diffplug.common.testing.TearDownAccepter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
@GwtCompatible
public class TearDownStack
implements TearDownAccepter {
    private static final Logger logger = Logger.getLogger(TearDownStack.class.getName());
    final LinkedList<TearDown> stack = new LinkedList();
    private final boolean suppressThrows;

    public TearDownStack() {
        this.suppressThrows = false;
    }

    public TearDownStack(boolean suppressThrows) {
        this.suppressThrows = suppressThrows;
    }

    @Override
    public final void addTearDown(TearDown tearDown) {
        this.stack.addFirst((TearDown)Preconditions.checkNotNull((Object)tearDown));
    }

    public final void runTearDown() {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (TearDown tearDown : this.stack) {
            try {
                tearDown.tearDown();
            }
            catch (Throwable t) {
                if (this.suppressThrows) {
                    logger.log(Level.INFO, "exception thrown during tearDown", t);
                    continue;
                }
                exceptions.add(t);
            }
        }
        this.stack.clear();
        if (!this.suppressThrows && exceptions.size() > 0) {
            throw ClusterException.create(exceptions);
        }
    }
}

