/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.util.concurrent.testing;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.util.concurrent.ForwardingListenableFuture;
import com.diffplug.common.util.concurrent.ListenableFuture;
import com.diffplug.common.util.concurrent.ListenableScheduledFuture;
import com.diffplug.common.util.concurrent.ListeningExecutorService;
import com.diffplug.common.util.concurrent.ListeningScheduledExecutorService;
import com.diffplug.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class SameThreadScheduledExecutorService
extends AbstractExecutorService
implements ListeningScheduledExecutorService {
    private final ListeningExecutorService delegate = MoreExecutors.newDirectExecutorService();

    SameThreadScheduledExecutorService() {
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        Preconditions.checkNotNull(task, (Object)"task must not be null!");
        return this.delegate.submit(task);
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        Preconditions.checkNotNull((Object)task, (Object)"task must not be null!");
        Preconditions.checkNotNull(result, (Object)"result must not be null!");
        return this.delegate.submit(task, result);
    }

    public ListenableFuture<?> submit(Runnable task) {
        Preconditions.checkNotNull((Object)task, (Object)"task must not be null!");
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Preconditions.checkNotNull(tasks, (Object)"tasks must not be null!");
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(tasks, (Object)"tasks must not be null!");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Preconditions.checkNotNull(tasks, (Object)"tasks must not be null!");
        return (T)this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull(tasks, (Object)"tasks must not be null!");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        Preconditions.checkNotNull((Object)command, (Object)"command must not be null!");
        this.delegate.execute(command);
    }

    public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Preconditions.checkNotNull((Object)command, (Object)"command must not be null");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
        return this.schedule(Executors.callable(command), delay, unit);
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(callable, (Object)"callable must not be null!");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
        ListenableFuture<V> delegateFuture = this.submit(callable);
        return new ImmediateScheduledFuture<V>(delegateFuture);
    }

    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException("scheduleAtFixedRate is not supported.");
    }

    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("scheduleWithFixedDelay is not supported.");
    }

    private static class ImmediateScheduledFuture<V>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
    implements ListenableScheduledFuture<V> {
        private ExecutionException exception;

        protected ImmediateScheduledFuture(ListenableFuture<V> future) {
            super(future);
        }

        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
            return (V)this.get();
        }

        public long getDelay(TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit must not be null!");
            return 0L;
        }

        public int compareTo(Delayed other) {
            Preconditions.checkNotNull((Object)other, (Object)"other must not be null!");
            return 0;
        }
    }
}

