/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import aQute.lib.filter.Filter;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.swt.os.OS;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.ZipUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.osgi.framework.Version;

public class PluginCatalog {
    private SetMultimap<String, Version> map = HashMultimap.create();
    private Set<String> unsupportedPlatform = Sets.newHashSet();
    private Map<String, List<Version>> resolvable = Maps.newHashMap();
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String BUNDLE_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String ECLIPSE_PLATFORM_FILTER = "Eclipse-PlatformFilter";

    public PluginCatalog(List<File> roots) {
        for (File root : roots) {
            List<File> files;
            Preconditions.checkArgument((boolean)root.exists(), (String)"Root '%s' does not exist.", (Object[])new Object[]{root});
            File pluginRoot = root;
            File plugins = root.toPath().resolve("plugins").toFile();
            if (plugins.exists()) {
                pluginRoot = plugins;
            }
            Preconditions.checkArgument(((files = Arrays.asList(pluginRoot.listFiles())).size() > 0 ? 1 : 0) != 0, (Object)("No plugins found in " + root));
            files.stream().filter(File::isFile).filter(file -> file.getName().endsWith(".jar")).filter(file -> !file.getName().endsWith("_SNAPSHOT.jar")).forEach(file -> {
                try {
                    ZipUtil.read(file, MANIFEST_PATH, (Throwing.Specific.Consumer<InputStream, IOException>)((Throwing.Specific.Consumer)input -> {
                        String platformFilter;
                        Manifest parsed = new Manifest((InputStream)input);
                        String name = parsed.getMainAttributes().getValue(BUNDLE_NAME);
                        int splitIdx = name.indexOf(59);
                        if (splitIdx > 0) {
                            name = name.substring(0, splitIdx);
                        }
                        if ((platformFilter = parsed.getMainAttributes().getValue(ECLIPSE_PLATFORM_FILTER)) != null) {
                            Filter filter = new Filter(platformFilter.replace(" ", ""));
                            boolean isSupportedOS = Arrays.asList(OS.values()).stream().map(SwtPlatform::fromOS).anyMatch(platform -> filter.match(new Hashtable(platform.platformProperties())));
                            if (!isSupportedOS) {
                                this.unsupportedPlatform.add(name);
                                return;
                            }
                        }
                        String versionRaw = parsed.getMainAttributes().getValue(BUNDLE_VERSION);
                        Version version = Version.parseVersion((String)versionRaw);
                        this.map.put((Object)name, (Object)version);
                    }));
                }
                catch (Exception e) {
                    throw Errors.asRuntime((Throwable)e);
                }
            });
        }
    }

    public void resolveWithFirst(String pluginName, String ... versions) {
        this.resolveWithFirst(pluginName, Arrays.asList(versions));
    }

    public void resolveWithFirst(String pluginName, List<String> versions) {
        this.resolvable.put(pluginName, versions.stream().map(Version::parseVersion).collect(Collectors.toList()));
    }

    public boolean isSupportedPlatform(String plugin) {
        return !this.unsupportedPlatform.contains(plugin);
    }

    public Version getVersionFor(String plugin) {
        Set versions = this.map.get((Object)plugin);
        if (versions.size() == 1) {
            return (Version)Iterables.get((Iterable)versions, (int)0);
        }
        if (versions.isEmpty()) {
            throw new IllegalArgumentException("No such plugin: " + plugin);
        }
        List<Version> resolveWith = this.resolvable.get(plugin);
        if (resolveWith == null) {
            throw new IllegalArgumentException("Conflicting versions for '" + plugin + "'! Available versions: '" + versions + "'.");
        }
        if (Sets.newHashSet(resolveWith).equals(versions)) {
            return resolveWith.get(0);
        }
        throw new IllegalArgumentException("Conflicts don't match!  Suggested resolution was " + resolveWith + ", but available was " + versions);
    }

    public String toString() {
        return this.map.entries().stream().map(entry -> entry.toString()).collect(Collectors.joining("\n"));
    }
}

