/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.MoreCollectors;
import com.diffplug.gradle.eclipse.EclipseWuff;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Project;

public class PdeBuild {
    private EclipseWuff eclipse;

    public PdeBuild(Project project) {
        this.eclipse = new EclipseWuff(project);
    }

    private File launcherJar() {
        List<File> files = Arrays.asList(this.eclipse.getSdkFile("plugins").listFiles());
        return (File)((Optional)files.stream().filter(file -> file.getName().startsWith("org.eclipse.equinox.launcher_")).filter(file -> file.getName().endsWith(".jar")).filter(File::isFile).collect(MoreCollectors.singleOrEmpty())).get();
    }

    private File pdeBuildFolder() {
        List<File> files = Arrays.asList(this.eclipse.getSdkFile("plugins").listFiles());
        return (File)((Optional)files.stream().filter(file -> file.getName().startsWith("org.eclipse.pde.build_")).filter(File::isDirectory).collect(MoreCollectors.singleOrEmpty())).get();
    }

    private File productBuildXml() {
        return this.pdeBuildFolder().toPath().resolve("scripts/productBuild/productBuild.xml").toFile();
    }

    public String productBuildCmd(File buildDir) {
        return this.antBuildCmd(this.productBuildXml()) + " -Dbuilder=" + PdeBuild.quote(buildDir);
    }

    public String antBuildCmd(File buildfile) {
        StringBuilder builder = new StringBuilder();
        builder.append("java -jar " + PdeBuild.quote(this.launcherJar()));
        builder.append(" -application org.eclipse.ant.core.antRunner");
        builder.append(" -buildfile " + PdeBuild.quote(buildfile));
        return builder.toString();
    }

    private static String quote(File toQuote) {
        return "\"" + toQuote.getAbsolutePath() + "\"";
    }
}

