/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.gradle.CmdLine;
import com.diffplug.gradle.eclipse.PdeBuild;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class PdeAntBuildTask
extends DefaultTask {
    private Object antFile;
    private Map<String, String> buildProperties = Maps.newLinkedHashMap();

    public void antFile(Object antFile) {
        this.antFile = antFile;
    }

    public void addProperty(String key, String value) {
        this.buildProperties.put(key, value);
    }

    public void addFileProperty(String key, Object value) {
        this.buildProperties.put(key, this.getProject().file(value).getAbsolutePath());
    }

    @TaskAction
    public void build() throws Exception {
        Preconditions.checkNotNull((Object)this.antFile, (Object)"antFile must not be null!");
        PdeBuild pdeBuild = new PdeBuild(this.getProject());
        StringBuilder cmd = new StringBuilder();
        cmd.append(pdeBuild.antBuildCmd(this.getProject().file(this.antFile)));
        for (Map.Entry<String, String> entry : this.buildProperties.entrySet()) {
            cmd.append(" -D");
            cmd.append(entry.getKey());
            cmd.append("=");
            cmd.append(entry.getValue());
        }
        CmdLine.runCmd(cmd.toString());
    }
}

