/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.CmdLine;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.ZipUtil;
import com.diffplug.gradle.eclipse.BuildProperties;
import com.diffplug.gradle.eclipse.PdeBuild;
import com.diffplug.gradle.eclipse.PluginCatalog;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class PdeProductBuildTask
extends DefaultTask {
    private Object buildDir;
    private Object pluginPath;
    private Object featureFolder;
    private Map<String, String> buildProperties = Maps.newLinkedHashMap();
    private Map<String, List<String>> resolveMap = Maps.newHashMap();
    private Object copyProductDir;
    private String dstRelPath;
    private static final String PRODUCT_FILE = "com.diffplug.core.product";
    private static final String PLUGIN_PREFIX = "<plugin id=\"";
    private static final String PLUGIN_MIDDLE = "\"";
    private static final String PLUGIN_SUFFIX = "/>";
    private static final String GROUP = "(.*)";
    private static final String NO_QUOTE_GROUP = "([^\"]*)";
    private static final Pattern PLUGIN_REGEX = Pattern.compile("(.*)<plugin id=\"([^\"]*)\"(.*)/>");
    private static final Pattern VERSION_REGEX = Pattern.compile("<product (?:.*) version=\"([^\"]*)\"(?:.*)>");

    public void buildDir(Object buildDir) {
        this.buildDir = buildDir;
    }

    @OutputDirectory
    protected File getBuildDir() {
        return this.getProject().file(this.buildDir);
    }

    public void setPluginPath(Object pluginPath) {
        this.pluginPath = pluginPath;
    }

    protected File getPluginPath() {
        return this.getProject().file(this.pluginPath);
    }

    public void setFeatureFolder(Object featureFolder) {
        this.featureFolder = featureFolder;
    }

    public void addBuildProperty(String key, String value) {
        this.buildProperties.put(key, value);
    }

    public void resolveWithFirst(String pluginName, String ... versions) {
        this.resolveMap.put(pluginName, Arrays.asList(versions));
    }

    public void copyProductAndImgs(Object src, String dstRelPath) {
        this.copyProductDir = src;
        this.dstRelPath = dstRelPath;
    }

    @TaskAction
    public void build() throws Exception {
        Preconditions.checkNotNull((Object)this.buildDir, (Object)"buildDir must not be null!");
        File buildDir = this.getBuildDir();
        FileMisc.cleanDir(buildDir);
        BuildProperties properties = new BuildProperties(this.getProject());
        properties.setConfigs(SwtPlatform.getAll());
        properties.setBuildDirectory(this.getBuildDir());
        if (this.pluginPath != null) {
            properties.setPluginPath(this.getPluginPath());
        } else {
            properties.setPluginPath(new File[0]);
        }
        for (Map.Entry<String, String> entry2 : this.buildProperties.entrySet()) {
            properties.setProp(entry2.getKey(), entry2.getValue());
        }
        File buildDirProperties = new File(buildDir, "build.properties");
        Files.write((CharSequence)properties.getContent(), (File)buildDirProperties, (Charset)StandardCharsets.UTF_8);
        if (this.copyProductDir != null) {
            File srcDir = this.getProject().file(this.copyProductDir);
            File dstDir = buildDir.toPath().resolve(this.dstRelPath).toFile();
            PluginCatalog catalog = new PluginCatalog(properties.getPluginLookupPath());
            this.resolveMap.entrySet().forEach(entry -> catalog.resolveWithFirst((String)entry.getKey(), (List)entry.getValue()));
            String dpVersion = (String)this.getProject().getProperties().get("VER_DIFFPLUG");
            File productInput = new File(srcDir, PRODUCT_FILE);
            File productOutput = new File(dstDir, PRODUCT_FILE);
            List lines = Files.readLines((File)productInput, (Charset)StandardCharsets.UTF_8);
            PdeProductBuildTask.setProductFileVersions(productInput, dpVersion, lines, catalog);
            productOutput.getParentFile().mkdirs();
            Files.write((CharSequence)Joiner.on((String)"\n").join((Iterable)lines), (File)productOutput, (Charset)StandardCharsets.UTF_8);
            File corePlugin = new File(this.getPluginPath(), "com.diffplug.core_" + dpVersion + ".jar");
            File temp = File.createTempFile("tempPlugin", ".jar");
            ZipUtil.modify(new FileInputStream(corePlugin), new FileOutputStream(temp), (Map<String, InputStream>)ImmutableMap.of((Object)PRODUCT_FILE, (Object)new FileInputStream(productOutput)), Collections.emptySet());
            Files.copy((File)temp, (File)corePlugin);
            temp.delete();
            ImmutableList endingsToCopy = ImmutableList.of((Object)".xpm", (Object)".icns", (Object)".ico");
            FileFilter filter = file -> file.isDirectory() || endingsToCopy.stream().anyMatch(ending -> file.getName().endsWith((String)ending));
            boolean preserveFileDate = false;
            FileUtils.copyDirectory((File)srcDir, (File)dstDir, (FileFilter)filter, (boolean)preserveFileDate);
        }
        if (this.featureFolder != null) {
            File feature = this.getProject().file(this.featureFolder);
            String featureId = feature.getName();
            FileUtils.copyDirectory((File)feature, (File)buildDir.toPath().resolve("features/" + featureId).toFile());
        }
        PdeBuild pdeBuild = new PdeBuild(this.getProject());
        CmdLine.runCmd(pdeBuild.productBuildCmd(buildDir));
    }

    public static void setProductFileVersions(File productFile, String version, List<String> lines, PluginCatalog catalog) {
        ListIterator<String> iter = lines.listIterator();
        Consumer<String> reportError = errorMsg -> {
            throw new IllegalArgumentException(productFile.getAbsolutePath() + ":" + (iter.previousIndex() + 1) + " " + (String)iter.previous() + "\n" + errorMsg);
        };
        while (iter.hasNext()) {
            Matcher pluginMatcher;
            String line = iter.next();
            Matcher productMatcher = VERSION_REGEX.matcher(line);
            if (productMatcher.matches()) {
                int start = productMatcher.start(1);
                int end = productMatcher.end(1);
                iter.set(line.substring(0, start) + version + line.substring(end));
            }
            if (!line.contains("plugin") || line.contains("plugins")) continue;
            if (line.contains("version=")) {
                reportError.accept("Plugins must not contain a version!  We're gonna add the version ourselves.");
            }
            if ((pluginMatcher = PLUGIN_REGEX.matcher(line)).matches()) {
                String pluginName = pluginMatcher.group(2);
                if (!catalog.isSupportedPlatform(pluginName)) {
                    iter.remove();
                    continue;
                }
                line = pluginMatcher.group(1) + PLUGIN_PREFIX + pluginName + PLUGIN_MIDDLE + " version=\"" + catalog.getVersionFor(pluginName) + PLUGIN_MIDDLE + pluginMatcher.group(3) + PLUGIN_SUFFIX;
                iter.set(line);
                continue;
            }
            reportError.accept("Unexpected line");
        }
    }
}

