/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class JDK {
    private final File rootFile;
    private final Path rootPath;
    private static final String KEY_JAVA = "org.gradle.java.home";

    public JDK(Project project) {
        this(new File((String)project.property(KEY_JAVA)));
    }

    public JDK(File rootFile) {
        this.rootFile = rootFile;
        this.rootPath = rootFile.toPath();
    }

    public File getBinDir() {
        return this.rootPath.resolve("bin").toFile();
    }

    public File getRootDir() {
        return this.rootFile;
    }

    public List<File> getJdkLibs() {
        Path jreLibBase = this.rootPath.resolve("jre/lib");
        return Arrays.asList("rt.jar", "jsse.jar", "jce.jar").stream().map(lib -> jreLibBase.resolve((String)lib).toFile()).collect(Collectors.toList());
    }
}

