/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.JDK;
import com.diffplug.gradle.eclipse.EclipseWuff;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class BuildProperties {
    private String content;
    private final EclipseWuff eclipse;
    private List<File> pluginPath = Lists.newArrayList();

    public static String rawFile() {
        try {
            URL url = BuildProperties.class.getResource("/template.build.properties");
            return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BuildProperties(Project project) {
        this.content = BuildProperties.rawFile();
        this.eclipse = new EclipseWuff(project);
        this.setJava8(project);
        this.setBasePlatform();
        this.setBaseEclipseSDK();
    }

    public String getContent() {
        return this.content;
    }

    public void setBuildDirectory(File buildDir) {
        this.setProp("buildDirectory", buildDir.getAbsolutePath());
    }

    public void setConfigs(Collection<SwtPlatform> platforms) {
        String value = platforms.stream().map(plat -> plat.getOs() + "," + plat.getWs() + "," + plat.getArch()).collect(Collectors.joining(" & \n"));
        this.setProp("configs", value);
    }

    private static String getSep() {
        return System.getProperty("path.separator");
    }

    public void setPluginPath(File ... dirs) {
        this.pluginPath.clear();
        this.pluginPath.addAll(Arrays.asList(dirs));
        this.pluginPath.add(this.eclipse.getDeltaPackDir());
        this.setProp("pluginPath", Joiner.on((String)BuildProperties.getSep()).join(this.pluginPath));
    }

    public List<File> getPluginLookupPath() {
        ArrayList files = Lists.newArrayList(this.pluginPath);
        files.add(0, this.eclipse.getSdkDir());
        return files;
    }

    private void setJava8(Project project) {
        JDK jdk = new JDK(project);
        String jdkLibs = jdk.getJdkLibs().stream().map(File::getAbsolutePath).collect(Collectors.joining(BuildProperties.getSep()));
        this.setTag("JRE", "JavaSE-1.8=\"" + jdkLibs + "\"");
        this.setProp("javacSource", "1.8");
        this.setProp("javacTarget", "1.8");
    }

    private void setBasePlatform() {
        SwtPlatform host = SwtPlatform.getNative();
        this.setProp("baseos", host.getOs());
        this.setProp("basews", host.getWs());
        this.setProp("basearch", host.getArch());
    }

    private void setBaseEclipseSDK() {
        this.setProp("base", this.eclipse.getSdkDir().getAbsolutePath());
    }

    private void setTag(String tag, String val) {
        this.replace(tag, val);
    }

    public void setProp(String key, String value) {
        if (this.content.contains(BuildProperties.tag_(key))) {
            this.replace(key, key + "=" + value);
        } else {
            if (!this.content.endsWith("\n")) {
                this.content = this.content + "\n";
            }
            this.content = this.content + key + "=" + BuildProperties.val_(value);
            this.content = this.content + "\n";
        }
    }

    private void replace(String tag, String value) {
        String modified = this.content.replace(BuildProperties.tag_(tag), BuildProperties.val_(value));
        Preconditions.checkState((!modified.equals(this.content) ? 1 : 0) != 0, (String)"No effect: %s to %s", (Object[])new Object[]{tag, value});
        this.content = modified;
    }

    private static String tag_(String key) {
        return "#{" + key + "}";
    }

    private static String val_(String val) {
        return val.replace("\\", "/").replace("\n", "\\\n");
    }
}

