/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.Comparison;
import com.diffplug.common.swt.os.OS;
import com.google.common.base.Preconditions;
import java.io.File;
import org.gradle.api.Project;
import org.osgi.framework.Version;

public class EclipseWuff {
    private final String version;
    private final Version versionOsgi;
    private static final Version MARS = Version.parseVersion((String)"4.5.0");

    private static File getWuffDir() {
        return new File(System.getProperty("user.home") + "/.wuff");
    }

    public EclipseWuff(Project project) {
        this.version = (String)project.getProperties().get("VER_ECLIPSE");
        this.versionOsgi = Version.parseVersion((String)this.version);
        Preconditions.checkNotNull((Object)this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public Version getVersionOsgi() {
        return this.versionOsgi;
    }

    public File getSdkDir() {
        return EclipseWuff.getWuffDir().toPath().resolve("unpacked/eclipse-SDK-" + this.version + "-" + EclipseWuff.getSuffixForThisOS()).toFile();
    }

    public File getSdkFile(String subPath) {
        return this.getSdkDir().toPath().resolve(subPath).toFile();
    }

    private static String getSuffixForThisOS() {
        String root = (String)OS.getNative().winMacLinux((Object)"win32", (Object)"macosx-cocoa", (Object)"linux-gtk");
        return (String)OS.getNative().getArch().x86x64((Object)root, (Object)(root + "-x86_64"));
    }

    public File getDeltaPackDir() {
        return EclipseWuff.getWuffDir().toPath().resolve("unpacked/eclipse-" + this.version + "-delta-pack").toFile();
    }

    public File getEclipseExecutable() {
        OS os = OS.getNative();
        if (os.isWindows()) {
            return this.getSdkFile("eclipse.exe");
        }
        if (os.isMac()) {
            String pre45 = "eclipse.app";
            String after45 = "Contents/MacOS/eclipse";
            String path = (String)Comparison.compare((Comparable)this.versionOsgi, (Comparable)MARS).lesserEqualGreater((Object)pre45, (Object)after45, (Object)after45);
            return this.getSdkFile(path);
        }
        return this.getSdkFile("eclipse");
    }

    public File getEclipseConsoleExecutable() {
        OS os = OS.getNative();
        if (os.isWindows()) {
            return this.getSdkFile("eclipsec.exe");
        }
        if (os.isMac()) {
            String pre45 = "eclipse.app/Contents/MacOS/eclipse";
            String after45 = "Contents/MacOS/eclipse";
            String path = (String)Comparison.compare((Comparable)this.versionOsgi, (Comparable)MARS).lesserEqualGreater((Object)pre45, (Object)after45, (Object)after45);
            return this.getSdkFile(path);
        }
        return this.getSdkFile("eclipse");
    }
}

